<?php
session_start();

if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit();
}

$role = $_SESSION['role'];

if ($role !== 'admin' && $role !== 'user') {
    echo "Access denied.";
    exit();
}

require_once 'db_connection.php';

$search_item_code = '';
if (isset($_POST['search_item_code'])) {
    $search_item_code = $_POST['search_item_code'];
}

// Pagination variables
$limit = 15; // Number of rows per page
$page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
$offset = ($page - 1) * $limit;

// Count total items for pagination
$count_sql = "SELECT COUNT(*) as total FROM item_profile";
if (!empty($search_item_code)) {
    $count_sql .= " WHERE item_code LIKE '%" . $conn->real_escape_string($search_item_code) . "%'";
}
$count_result = $conn->query($count_sql);
$total_items = $count_result->fetch_assoc()['total'];
$total_pages = ceil($total_items / $limit);

// Fetch items with limit and offset
$sql = "SELECT * FROM item_profile ORDER BY item_id DESC";
if (!empty($search_item_code)) {
    $sql .= " WHERE item_code LIKE '%" . $conn->real_escape_string($search_item_code) . "%'";
}
$sql .= " LIMIT $limit OFFSET $offset";
$result = $conn->query($sql);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Item List</title>
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
</head>
<body>
<?php require_once 'menu.html';?>

<div class="container mt-5">
    <h2>Item List</h2>
    <a href='create_item_profile.php' class="btn btn-primary mb-3">Add New Item</a>
    <form method="post" class="form-inline mb-4">
        <input type="text" name="search_item_code" class="form-control mr-2" placeholder="Search by Item Code" value="<?php echo htmlspecialchars($search_item_code); ?>">
        <button type="submit" class="btn btn-primary">Search</button> 
    </form>
    <table class="table table-bordered">
        <thead>
            <tr>
                <th>Item Code</th>
                <th>Item Name</th>
                <th>Item Price</th>
                <th>Item Category</th>
                <th>Item Type</th>
                <th>Create Date</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            <?php
            if ($result->num_rows > 0) {
                while ($row = $result->fetch_assoc()) {
                    echo "<tr>
                            <td>{$row['item_code']}</td>
                            <td>{$row['item_name']}</td>
                            <td>{$row['item_price']}</td>
                            <td>{$row['item_category']}</td>
                            <td>{$row['item_type']}</td>
                            <td>{$row['create_date']}</td>
                            <td>
                                <a href='view_item.php?item_id={$row['item_id']}' class='btn btn-info'>View</a>       
                                <a href='edit_item.php?item_id={$row['item_id']}' class='btn btn-warning'>Edit</a>
                                <a href='delete_item.php?item_id={$row['item_id']}' class='btn btn-danger'>Delete</a>
                            </td>
                        </tr>";
                }
            } else {
                echo "<tr><td colspan='7'>No items found</td></tr>";
            }
            ?>
        </tbody>
    </table>
    
    <!-- Pagination Links -->
    <nav aria-label="Page navigation">
        <ul class="pagination">
            <?php if ($page > 1): ?>
                <li class="page-item"><a class="page-link" href="?page=<?php echo $page - 1; ?>&search_item_code=<?php echo htmlspecialchars($search_item_code); ?>">Previous</a></li>
            <?php endif; ?>
            <?php for ($i = 1; $i <= $total_pages; $i++): ?>
                <li class="page-item <?php echo ($i == $page) ? 'active' : ''; ?>"><a class="page-link" href="?page=<?php echo $i; ?>&search_item_code=<?php echo htmlspecialchars($search_item_code); ?>"><?php echo $i; ?></a></li>
            <?php endfor; ?>
            <?php if ($page < $total_pages): ?>
                <li class="page-item"><a class="page-link" href="?page=<?php echo $page + 1; ?>&search_item_code=<?php echo htmlspecialchars($search_item_code); ?>">Next</a></li>
            <?php endif; ?>
        </ul>
    </nav>
</div>
</body>
</html>

<?php
$conn->close();
?>
