<?php
session_start();

if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit();
}

$role = $_SESSION['role'];

if ($role !== 'admin' && $role !== 'user') {
    echo "Access denied.";
    exit();
}

require_once 'db_connection.php';

// Initialize search variables
$search_invoice_no = '';
$search_invoice_date = '';
$limit = 15;
$page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
$offset = ($page - 1) * $limit;

$where = [];

// Capture search inputs
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    if (!empty($_POST['search_invoice_no'])) {
        $search_invoice_no = $_POST['search_invoice_no'];
        $where[] = "invoice_no LIKE '%" . $conn->real_escape_string($search_invoice_no) . "%'";
    }
    if (!empty($_POST['search_invoice_date'])) {
        $search_invoice_date = $_POST['search_invoice_date'];
        $where[] = "invoice_date = '" . $conn->real_escape_string($search_invoice_date) . "'";
    }
}

$where_sql = count($where) ? 'WHERE ' . implode(' AND ', $where) : '';

// Get total rows for pagination
$sql_count = "SELECT COUNT(*) as count FROM invoice_master $where_sql";
$result_count = $conn->query($sql_count);
$total_rows = $result_count->fetch_assoc()['count'];
$total_pages = ceil($total_rows / $limit);

// Fetch invoice data with limit and offset
$sql = "SELECT * FROM invoice_master $where_sql LIMIT $limit OFFSET $offset";
$result = $conn->query($sql);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Invoice List</title>
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
</head>
<body>
<?php require_once 'menu.html';?>

<div class="container mt-5">
    <h2>Invoice List</h2>
    <a href='invoice.php' class="btn btn-primary mb-3">Create New Invoice</a>
    <form method="post" class="form-inline mb-4">
        <input type="text" name="search_invoice_no" class="form-control mr-2" placeholder="Search by Invoice No" value="<?php echo htmlspecialchars($search_invoice_no); ?>">
        <input type="date" name="search_invoice_date" class="form-control mr-2" placeholder="Search by Date" value="<?php echo htmlspecialchars($search_invoice_date); ?>">
        <button type="submit" class="btn btn-primary">Search</button>
    </form>
    <table class="table table-bordered">
        <thead>
            <tr>
                <th>Invoice No</th>
                <th>Customer Name</th>
                <th>Invoice Date</th>
                <th>Salesman</th>
                <th>Total Amount</th>
                <th>Balance</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            <?php
            if ($result->num_rows > 0) {
                while ($row = $result->fetch_assoc()) {
                    echo "<tr>
                            <td>{$row['invoice_no']}</td>
                            <td>{$row['customer_name']}</td>
                            <td>{$row['invoice_date']}</td>
                            <td>{$row['salesman']}</td>
                            <td>{$row['total_amount']}</td>
                            <td>{$row['balance']}</td>
                            <td>
                                <a href='view_invoice.php?invoice_no={$row['invoice_no']}' class='btn btn-info'>View</a>       
                                <a href='edit_invoice.php?invoice_no={$row['invoice_no']}' class='btn btn-warning'>Edit</a>
                                <a href='delete_invoice.php?invoice_no={$row['invoice_no']}' class='btn btn-danger'>Delete</a>
                            </td>
                        </tr>";
                }
            } else {
                echo "<tr><td colspan='7'>No invoices found</td></tr>";
            }
            ?>
        </tbody>
    </table>
    <nav aria-label="Page navigation">
        <ul class="pagination justify-content-center">
            <?php
            for ($i = 1; $i <= $total_pages; $i++) {
                echo "<li class='page-item " . ($page == $i ? 'active' : '') . "'><a class='page-link' href='list_invoices.php?page=$i'>$i</a></li>";
            }
            ?>
        </ul>
    </nav>
</div>
</body>
</html>

<?php
$conn->close();
?>
