<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Item Adjustment Form</title>
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <style>
        body {
            background-color: #f8f9fa;
            padding: 20px;
        }
        .container {
            background-color: #fff;
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
        }
        .form-section {
            margin-bottom: 30px;
        }
        .form-section h3 {
            margin-bottom: 20px;
            color: #007bff;
        }
    </style>
</head>
<body>
<?php require_once 'menu.html';?>
    <div class="container">
        <h2 class="text-center">Item Adjustment Form</h2>
        <form action="save_item_adjustment.php" method="POST">
            <div class="form-group">
                <label for="date">Date</label>
                <input type="date" class="form-control" id="date" name="date" required>
            </div>
            <div class="form-group">
                <label for="item_code">Item Code</label>
                <input type="text" class="form-control" id="item_code" name="item_code" required onblur="fetchItemName()">
            </div>
            <div class="form-group">
                <label for="item_name">Item Name</label>
                <input type="text" class="form-control" id="item_name" name="item_name" readonly required>
            </div>
            <div class="form-group">
                <label for="quantity">Quantity</label>
                <input type="number" step="0.01" class="form-control" id="quantity" name="quantity" required>
            </div>
            <div class="form-group">
                <label for="status">Status</label>
                <select class="form-control" id="status" name="status" required>
                    <option value="">Select Status</option>
                    <option value="Washing">Washing</option>
                    <option value="Damage">Damage</option>
                    <option value="Other">Other</option>
                </select>
            </div>
            <div class="form-group">
                <label for="task">Task</label>
                <select class="form-control" id="task" name="task" required>
                    <option value="">Select Task</option>
                    <option value="In">In</option>
                    <option value="Out">Out</option>
                </select>
            </div>
            <div class="form-group">
                <label for="remark">Remark</label>
                <textarea class="form-control" id="remark" name="remark" rows="3"></textarea>
            </div>
            <button type="submit" class="btn btn-primary">Save Adjustment</button>
        </form>
    </div>

    <script>
        function fetchItemName() {
            var itemCode = document.getElementById("item_code").value;
            if (itemCode) {
                fetch("fetch_item_ajest_name.php?item_code=" + itemCode)
                    .then(response => response.json())
                    .then(data => {
                        document.getElementById("item_name").value = data.item_name ? data.item_name : "Item not found";
                    });
            } else {
                document.getElementById("item_name").value = '';
            }
        }
    </script>
</body>
</html>
