<?php
require_once 'db_connection.php';

// Get the customer return ID from the URL
if (isset($_GET['cus_rtn_id'])) {
    $cus_rtn_id = $_GET['cus_rtn_id'];

    // Fetch the master details
    $masterQuery = $conn->prepare("SELECT * FROM customer_return_master WHERE cus_rtn_id = ?");
    
    if ($masterQuery === false) {
        die("Error in query: " . $conn->error);
    }
    
    $masterQuery->bind_param("i", $cus_rtn_id);
    $masterQuery->execute();
    $masterResult = $masterQuery->get_result();
    $masterData = $masterResult->fetch_assoc();

    // Fetch the details section data
    $detailsQuery = $conn->prepare("SELECT * FROM customer_details WHERE cus_rtn_id = ?");
    
    if ($detailsQuery === false) {
        die("Error in query: " . $conn->error);
    }
    
    $detailsQuery->bind_param("i", $cus_rtn_id);
    $detailsQuery->execute();
    $detailsResult = $detailsQuery->get_result();
} else {
    echo "Invalid request.";
    exit;
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>View Customer Return</title>
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <style>
        body {
            background-color: #f8f9fa;
            padding: 20px;
        }
        .container {
            background-color: #fff;
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
        }
        .table th, .table td {
            vertical-align: middle;
        }
    </style>
</head>
<body>
<?php require_once 'menu.html';?>
    <div class="container">
        <h2 class="text-center mb-4">View Customer Return</h2>

        <!-- Master Section -->
        <div class="form-group">
            <label><strong>Invoice No:</strong></label>
            <p><?= $masterData['invoice_no'] ?></p>
        </div>
        <div class="form-group">
            <label><strong>Customer Name:</strong></label>
            <p><?= $masterData['customer_name'] ?></p>
        </div>
        <div class="form-group">
            <label><strong>Date:</strong></label>
            <p><?= $masterData['date'] ?></p>
        </div>
        <div class="form-group">
            <label><strong>Salesman:</strong></label>
            <p><?= $masterData['salesman'] ?></p>
        </div>
        <div class="form-group">
            <label><strong>Return Value:</strong></label>
            <p><?= $masterData['rtn_value'] ?></p>
        </div>

        <!-- Details Section -->
        <h4>Details</h4>
        <table class="table table-bordered table-hover mt-4">
            <thead class="thead-dark">
                <tr>
                    <th>Item Code</th>
                    <th>Item Name</th>
                    <th>Quantity</th>
                    <th>Amount</th>
                    <th>Subtotal</th>
                    <th>Remark</th>
                </tr>
            </thead>
            <tbody>
                <?php while ($row = $detailsResult->fetch_assoc()): ?>
                    <tr>
                        <td><?= $row['item_code'] ?></td>
                        <td><?= $row['item_name'] ?></td>
                        <td><?= $row['quantity'] ?></td>
                        <td><?= $row['amount'] ?></td>
                        <td><?= $row['subtotal'] ?></td>
                        <td><?= $row['remark'] ?></td>
                    </tr>
                <?php endwhile; ?>
            </tbody>
        </table>

        <div class="text-right">
            <a href="list_cus_rtn.php" class="btn btn-primary">Back to List</a>
        </div>
    </div>
</body>
</html>

<?php
// Close the database connection
$conn->close();
?>
