<?php
session_start();

if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit();
}

$role = $_SESSION['role'];

if ($role !== 'admin' && $role !== 'user') {
    echo "Access denied.";
    exit();
}

require_once 'db_connection.php';

// Search variables
$search_item_code = '';
$search_category = '';
$search_colour = '';
$search_size = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $search_item_code = $_POST['search_item_code'] ?? '';
    $search_category = $_POST['search_category'] ?? '';
    $search_colour = $_POST['search_colour'] ?? '';
    $search_size = $_POST['search_size'] ?? '';
}

// Pagination variables
$limit = 50; // Number of rows per page
$page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
$offset = ($page - 1) * $limit;

// Base SQL query
$sql = "SELECT * FROM item_profile WHERE 1=1";

// Append search conditions to SQL query
if (!empty($search_item_code)) {
    $sql .= " AND item_code LIKE '%" . $conn->real_escape_string($search_item_code) . "%'";
}
if (!empty($search_category)) {
    $sql .= " AND item_category LIKE '%" . $conn->real_escape_string($search_category) . "%'";
}
if (!empty($search_colour)) {
    $sql .= " AND item_colour LIKE '%" . $conn->real_escape_string($search_colour) . "%'";
}
if (!empty($search_size)) {
    $sql .= " AND item_size LIKE '%" . $conn->real_escape_string($search_size) . "%'";
}

// Count total items for pagination
$count_sql = "SELECT COUNT(*) as total FROM item_profile WHERE 1=1";
if (!empty($search_item_code)) {
    $count_sql .= " AND item_code LIKE '%" . $conn->real_escape_string($search_item_code) . "%'";
}
if (!empty($search_category)) {
    $count_sql .= " AND item_category LIKE '%" . $conn->real_escape_string($search_category) . "%'";
}
if (!empty($search_colour)) {
    $count_sql .= " AND item_colour LIKE '%" . $conn->real_escape_string($search_colour) . "%'";
}
if (!empty($search_size)) {
    $count_sql .= " AND item_size LIKE '%" . $conn->real_escape_string($search_size) . "%'";
}

$count_result = $conn->query($count_sql);
$total_items = $count_result->fetch_assoc()['total'];
$total_pages = ceil($total_items / $limit);

// Add ORDER BY and pagination (LIMIT and OFFSET)
$sql .= " ORDER BY item_id DESC LIMIT $limit OFFSET $offset";

$result = $conn->query($sql);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Item List</title>
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
</head>

<body>
<?php require_once 'menu.html'; ?>

<div class="container mt-5">
    <h2>Item List</h2>
    <div class="container mt-5">
    <h2>Item List</h2>
    <a href='create_item_profile.php' class="btn btn-primary mb-3">Add New Item</a>

    <a href='create_item_profile.php' class="btn btn-primary mb-3">Add New Item</a>
    
  <!-- Search Form -->
<form method="post" class="form-inline mb-4">
    <input type="text" name="search_item_code" class="form-control mr-2" placeholder="Search by Item Code" value="<?php echo htmlspecialchars($search_item_code); ?>">
    <input type="text" name="search_category" class="form-control mr-2" placeholder="Search by Category" value="<?php echo htmlspecialchars($search_category); ?>">
    <label for="search_colour" class="mr-2">Search by Color:</label>
    <select name="search_colour" class="form-control mr-2">
    <option value="" <?php echo $search_colour === '' ? 'selected' : ''; ?>></option>
        <option value="-----" <?php echo $search_colour === '-----' ? 'selected' : ''; ?>>-----</option>
        <option value="Beige" <?php echo $search_colour === 'Beige' ? 'selected' : ''; ?>>Beige</option>
        <option value="Black" <?php echo $search_colour === 'Black' ? 'selected' : ''; ?>>Black</option>
        <option value="Check ash" <?php echo $search_colour === 'Check ash' ? 'selected' : ''; ?>>Check ash</option>
        <option value="Check blue" <?php echo $search_colour === 'Check blue' ? 'selected' : ''; ?>>Check blue</option>
        <option value="Check grey" <?php echo $search_colour === 'Check grey' ? 'selected' : ''; ?>>Check grey</option>
        <option value="Check lite ash" <?php echo $search_colour === 'Check lite ash' ? 'selected' : ''; ?>>Check lite ash</option>
        <option value="Check meroon" <?php echo $search_colour === 'Check meroon' ? 'selected' : ''; ?>>Check meroon</option>
        <option value="Chocolate brown" <?php echo $search_colour === 'Chocolate brown' ? 'selected' : ''; ?>>Chocolate brown</option>
        <option value="Cotton ash" <?php echo $search_colour === 'Cotton ash' ? 'selected' : ''; ?>>Cotton ash</option>
        <option value="Cotton ash brown" <?php echo $search_colour === 'Cotton ash brown' ? 'selected' : ''; ?>>Cotton ash brown</option>
        <option value="Cotton beige" <?php echo $search_colour === 'Cotton beige' ? 'selected' : ''; ?>>Cotton beige</option>
        <option value="Cotton blue" <?php echo $search_colour === 'Cotton blue' ? 'selected' : ''; ?>>Cotton blue</option>
        <option value="Cotton dark brown" <?php echo $search_colour === 'Cotton dark brown' ? 'selected' : ''; ?>>Cotton dark brown</option>
        <option value="Dark ash" <?php echo $search_colour === 'Dark ash' ? 'selected' : ''; ?>>Dark ash</option>
        <option value="Dark brown" <?php echo $search_colour === 'Dark brown' ? 'selected' : ''; ?>>Dark brown</option>
        <option value="Dark green" <?php echo $search_colour === 'Dark green' ? 'selected' : ''; ?>>Dark green</option>
        <option value="Floral black" <?php echo $search_colour === 'Floral black' ? 'selected' : ''; ?>>Floral black</option>
        <option value="Floral green" <?php echo $search_colour === 'Floral green' ? 'selected' : ''; ?>>Floral green</option>
        <option value="Floral orange" <?php echo $search_colour === 'Floral orange' ? 'selected' : ''; ?>>Floral orange</option>
        <option value="Grey" <?php echo $search_colour === 'Grey' ? 'selected' : ''; ?>>Grey</option>
        <option value="Lavendra ash" <?php echo $search_colour === 'Lavendra ash' ? 'selected' : ''; ?>>Lavendra ash</option>
        <option value="Lavendra blue" <?php echo $search_colour === 'Lavendra blue' ? 'selected' : ''; ?>>Lavendra blue</option>
        <option value="Lite green" <?php echo $search_colour === 'Lite green' ? 'selected' : ''; ?>>Lite green</option>
        <option value="Lite pink" <?php echo $search_colour === 'Lite pink' ? 'selected' : ''; ?>>Lite pink</option>
        <option value="Meroon" <?php echo $search_colour === 'Meroon' ? 'selected' : ''; ?>>Meroon</option>
        <option value="Mix lavendra ash" <?php echo $search_colour === 'Mix lavendra ash' ? 'selected' : ''; ?>>Mix lavendra ash</option>
        <option value="Moose green" <?php echo $search_colour === 'Moose green' ? 'selected' : ''; ?>>Moose green</option>
        <option value="Navy blue" <?php echo $search_colour === 'Navy blue' ? 'selected' : ''; ?>>Navy blue</option>
        <option value="New dark blue" <?php echo $search_colour === 'New dark blue' ? 'selected' : ''; ?>>New dark blue</option>
        <option value="Pink" <?php echo $search_colour === 'Pink' ? 'selected' : ''; ?>>Pink</option>
        <option value="purple" <?php echo $search_colour === 'purple' ? 'selected' : ''; ?>>purple</option>
        <option value="Royal blue" <?php echo $search_colour === 'Royal blue' ? 'selected' : ''; ?>>Royal blue</option>
        <option value="Shine ash" <?php echo $search_colour === 'Shine ash' ? 'selected' : ''; ?>>Shine ash</option>
        <option value="Shine beige" <?php echo $search_colour === 'Shine beige' ? 'selected' : ''; ?>>Shine beige</option>
        <option value="Shine black" <?php echo $search_colour === 'Shine black' ? 'selected' : ''; ?>>Shine black</option>
        <option value="Shine blue" <?php echo $search_colour === 'Shine blue' ? 'selected' : ''; ?>>Shine blue</option>
        <option value="Shine meroon" <?php echo $search_colour === 'Shine meroon' ? 'selected' : ''; ?>>Shine meroon</option>
        <option value="Shine pencil blue" <?php echo $search_colour === 'Shine pencil blue' ? 'selected' : ''; ?>>Shine pencil blue</option>
        <option value="Sky blue" <?php echo $search_colour === 'Sky blue' ? 'selected' : ''; ?>>Sky blue</option>
    </select>
    
    <input type="text" name="search_size" class="form-control mr-2" placeholder="Search by Size" value="<?php echo htmlspecialchars($search_size); ?>">
    <button type="submit" class="btn btn-primary">Search</button>
</form>

<form method="post" action="print_report.php" target="_blank" class="form-inline mb-4">
    <input type="hidden" name="search_item_code" value="<?php echo htmlspecialchars($search_item_code); ?>">
    <input type="hidden" name="search_category" value="<?php echo htmlspecialchars($search_category); ?>">
    <input type="hidden" name="search_colour" value="<?php echo htmlspecialchars($search_colour); ?>">
    <input type="hidden" name="search_size" value="<?php echo htmlspecialchars($search_size); ?>">
    <button type="submit" class="btn btn-secondary ml-2">Print Report</button>
</form>

 <!-- Total records count -->
 <?php if ($total_items > 0): ?>
        <p class="text-info">Total records found: <?php echo $total_items; ?></p>
    <?php else: ?>
        <p class="text-danger">No records found.</p>
    <?php endif; ?>

    <table class="table table-bordered">
        <thead>
            <tr>
                <th>Item Code</th>
                <th>Item Name</th>
                <th>Item Price</th>
                <th>Item Category</th>
                <th>Item Colour</th>
                <th>Item Size</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            <?php
            if ($result->num_rows > 0) {
                while ($row = $result->fetch_assoc()) {
                    echo "<tr>
                            <td>{$row['item_code']}</td>
                            <td>{$row['item_name']}</td>
                            <td>{$row['item_price']}</td>
                            <td>{$row['item_category']}</td>
                            <td>{$row['item_colour']}</td>
                            <td>{$row['item_size']}</td>
                            <td>
                                <a href='view_item.php?item_id={$row['item_id']}' class='btn btn-info'>View</a>
                                <a href='edit_item.php?item_id={$row['item_id']}' class='btn btn-warning'>Edit</a>
                                <a href='delete_item.php?item_id={$row['item_id']}' class='btn btn-danger'>Delete</a>
                            </td>
                        </tr>";
                }
            } else {
                echo "<tr><td colspan='7'>No items found</td></tr>";
            }
            ?>
        </tbody>
    </table>

    <!-- Pagination Links -->
    <nav aria-label="Page navigation">
        <ul class="pagination">
            <?php if ($page > 1): ?>
                <li class="page-item">
                    <a class="page-link" href="?page=<?php echo $page - 1; ?>">Previous</a>
                </li>
            <?php endif; ?>
            <?php for ($i = 1; $i <= $total_pages; $i++): ?>
                <li class="page-item <?php echo ($i == $page) ? 'active' : ''; ?>">
                    <a class="page-link" href="?page=<?php echo $i; ?>"><?php echo $i; ?></a>
                </li>
            <?php endfor; ?>
            <?php if ($page < $total_pages): ?>
                <li class="page-item">
                    <a class="page-link" href="?page=<?php echo $page + 1; ?>">Next</a>
                </li>
            <?php endif; ?>
        </ul>
    </nav>
</div>

</body>
</html>

<?php
$conn->close();
?>
