<?php
session_start();

if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit();
}

$role = $_SESSION['role'];

if ($role !== 'admin' && $role !== 'user') {
    echo "Access denied.";
    exit();
}

require_once 'db_connection.php';

if (!isset($_GET['item_id'])) {
    die("Error: Item ID not provided.");
}

$item_id = $_GET['item_id'];

$sql = "SELECT * FROM item_profile WHERE item_id='$item_id'";
$result = $conn->query($sql);

if ($result->num_rows == 0) {
    die("Error: Item not found.");
}

$row = $result->fetch_assoc();

// Fetch categories from the database
$sql_categories = "SELECT category_name FROM category_profile";
$result_categories = $conn->query($sql_categories);
$categories = [];
if ($result_categories->num_rows > 0) {
    while ($category_row = $result_categories->fetch_assoc()) {
        $categories[] = $category_row['category_name'];
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Edit Item Profile</title>
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
</head>
<body>
<?php require_once 'menu.html'; ?>
<div class="container mt-5">
    <h2>Edit Item Profile</h2>
    <form action="process_edit_item.php" method="post">
        <input type="hidden" name="item_id" value="<?php echo $row['item_id']; ?>">

        <div class="form-row">
            <div class="form-group col-md-6">
                <label for="item_code">Item Code:</label>
                <input type="text" id="item_code" name="item_code" class="form-control" value="<?php echo $row['item_code']; ?>" >
            </div>
            <div class="form-group col-md-6">
                <label for="item_name">Item Name:</label>
                <input type="text" id="item_name" name="item_name" class="form-control" value="<?php echo $row['item_name']; ?>" required>
            </div>
        </div>

        <div class="form-row">
            <div class="form-group col-md-6">
                <label for="item_price">Item Price:</label>
                <input type="number" id="item_price" name="item_price" class="form-control" value="<?php echo $row['item_price']; ?>" step="0.01" required>
            </div>
            <div class="form-group col-md-6">
                <label for="item_category">Item Category:</label>
                <select id="item_category" name="item_category" class="form-control" required>
                    <option value="">Select a Category</option>
                    <?php foreach ($categories as $category): ?>
                        <option value="<?php echo htmlspecialchars($category); ?>" <?php if ($row['item_category'] == $category) echo 'selected'; ?>>
                            <?php echo htmlspecialchars($category); ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </div>
        </div>

        <div class="form-row">
            <div class="form-group col-md-6">
                <label for="item_type">Item Type:</label>
                <select id="item_type" name="item_type" class="form-control" required>
                    <option value="Raw Material" <?php if ($row['item_type'] == 'Raw Material') echo 'selected'; ?>>Raw Material</option>
                    <option value="Rent Item" <?php if ($row['item_type'] == 'Rent Item') echo 'selected'; ?>>Rent Item</option>
                    <option value="Sell Item" <?php if ($row['item_type'] == 'Sell Item') echo 'selected'; ?>>Sell Item</option>
                </select>
            </div>
            <div class="form-group col-md-6">
                <label for="create_date">Create Date:</label>
                <input type="date" id="create_date" name="create_date" class="form-control" value="<?php echo $row['create_date']; ?>" required>
            </div>
        </div>

        <div class="form-row">
            <div class="form-group col-md-6">
                <label for="item_description">Item Description:</label>
                <textarea id="item_description" name="item_description" class="form-control" rows="3"><?php echo $row['item_description']; ?></textarea>
            </div>

            <div class="form-group col-md-6">
                <label for="unit_ok">Unit:</label>
                <select id="unit_ok" name="unit_ok" class="form-control" required>
                    <option value="Each" <?php if ($row['unit_ok'] == 'Each') echo 'selected'; ?>>Each</option>
                    <option value="Yards" <?php if ($row['unit_ok'] == 'Yards') echo 'selected'; ?>>Yards</option>
                    <option value="M" <?php if ($row['unit_ok'] == 'M') echo 'selected'; ?>>M</option>
                    <option value="KG" <?php if ($row['unit_ok'] == 'KG') echo 'selected'; ?>>KG</option>                         
                </select>
            </div>
        </div>

        <!-- New Fields: Colour and Size -->
        <div class="form-row">
            <div class="form-group col-md-6">
                <label for="item_colour">Item Colour:</label>
                <select id="item_colour" name="item_colour" class="form-control" required>
                    <option value="">Select Colour</option>
                   
<option value="-----" <?php if ($row['item_colour'] == '-----') echo 'selected'; ?>>-----</option>
<option value="Beige" <?php if ($row['item_colour'] == 'Beige') echo 'selected'; ?>>Beige</option>
<option value="Black" <?php if ($row['item_colour'] == 'Black') echo 'selected'; ?>>Black</option>
<option value="Check ash" <?php if ($row['item_colour'] == 'Check ash') echo 'selected'; ?>>Check ash</option>
<option value="Check blue" <?php if ($row['item_colour'] == 'Check blue') echo 'selected'; ?>>Check blue</option>
<option value="Check grey" <?php if ($row['item_colour'] == 'Check grey') echo 'selected'; ?>>Check grey</option>
<option value="Check lite ash" <?php if ($row['item_colour'] == 'Check lite ash') echo 'selected'; ?>>Check lite ash</option>
<option value="Check meroon" <?php if ($row['item_colour'] == 'Check meroon') echo 'selected'; ?>>Check meroon</option>
<option value="Chocolate brown" <?php if ($row['item_colour'] == 'Chocolate brown') echo 'selected'; ?>>Chocolate brown</option>
<option value="Cotton ash" <?php if ($row['item_colour'] == 'Cotton ash') echo 'selected'; ?>>Cotton ash</option>
<option value="Cotton ash brown" <?php if ($row['item_colour'] == 'Cotton ash brown') echo 'selected'; ?>>Cotton ash brown</option>
<option value="Cotton beige" <?php if ($row['item_colour'] == 'Cotton beige') echo 'selected'; ?>>Cotton beige</option>
<option value="Cotton blue" <?php if ($row['item_colour'] == 'Cotton blue') echo 'selected'; ?>>Cotton blue</option>
<option value="Cotton dark brown" <?php if ($row['item_colour'] == 'Cotton dark brown') echo 'selected'; ?>>Cotton dark brown</option>
<option value="Dark ash" <?php if ($row['item_colour'] == 'Dark ash') echo 'selected'; ?>>Dark ash</option>
<option value="Dark brown" <?php if ($row['item_colour'] == 'Dark brown') echo 'selected'; ?>>Dark brown</option>
<option value="Dark green" <?php if ($row['item_colour'] == 'Dark green') echo 'selected'; ?>>Dark green</option>
<option value="Floral black" <?php if ($row['item_colour'] == 'Floral black') echo 'selected'; ?>>Floral black</option>
<option value="Floral green" <?php if ($row['item_colour'] == 'Floral green') echo 'selected'; ?>>Floral green</option>
<option value="Floral orange" <?php if ($row['item_colour'] == 'Floral orange') echo 'selected'; ?>>Floral orange</option>
<option value="Grey" <?php if ($row['item_colour'] == 'Grey') echo 'selected'; ?>>Grey</option>
<option value="Lavendra ash" <?php if ($row['item_colour'] == 'Lavendra ash') echo 'selected'; ?>>Lavendra ash</option>
<option value="Lavendra blue" <?php if ($row['item_colour'] == 'Lavendra blue') echo 'selected'; ?>>Lavendra blue</option>
<option value="Lite green" <?php if ($row['item_colour'] == 'Lite green') echo 'selected'; ?>>Lite green</option>
<option value="Lite pink" <?php if ($row['item_colour'] == 'Lite pink') echo 'selected'; ?>>Lite pink</option>
<option value="Meroon" <?php if ($row['item_colour'] == 'Meroon') echo 'selected'; ?>>Meroon</option>
<option value="Mix lavendra ash" <?php if ($row['item_colour'] == 'Mix lavendra ash') echo 'selected'; ?>>Mix lavendra ash</option>
<option value="Moose green" <?php if ($row['item_colour'] == 'Moose green') echo 'selected'; ?>>Moose green</option>
<option value="Navy blue" <?php if ($row['item_colour'] == 'Navy blue') echo 'selected'; ?>>Navy blue</option>
<option value="New dark blue" <?php if ($row['item_colour'] == 'New dark blue') echo 'selected'; ?>>New dark blue</option>
<option value="Pink" <?php if ($row['item_colour'] == 'Pink') echo 'selected'; ?>>Pink</option>
<option value="Purple" <?php if ($row['item_colour'] == 'Purple') echo 'selected'; ?>>Purple</option>
<option value="Royal blue" <?php if ($row['item_colour'] == 'Royal blue') echo 'selected'; ?>>Royal blue</option>
<option value="Shine ash" <?php if ($row['item_colour'] == 'Shine ash') echo 'selected'; ?>>Shine ash</option>
<option value="Shine beige" <?php if ($row['item_colour'] == 'Shine beige') echo 'selected'; ?>>Shine beige</option>
<option value="Shine black" <?php if ($row['item_colour'] == 'Shine black') echo 'selected'; ?>>Shine black</option>
<option value="Shine blue" <?php if ($row['item_colour'] == 'Shine blue') echo 'selected'; ?>>Shine blue</option>
<option value="Shine meroon" <?php if ($row['item_colour'] == 'Shine meroon') echo 'selected'; ?>>Shine meroon</option>
<option value="Shine pencil blue" <?php if ($row['item_colour'] == 'Shine pencil blue') echo 'selected'; ?>>Shine pencil blue</option>
<option value="Sky blue" <?php if ($row['item_colour'] == 'Sky blue') echo 'selected'; ?>>Sky blue</option>

                </select>
            </div>

            <div class="form-group col-md-6">
                <label for="item_size">Item Size:</label>
                <select id="item_size" name="item_size" class="form-control" required>
                    <option value="">Select Size</option>
                    
<option value="----" <?php if ($row['item_size'] == '----') echo 'selected'; ?>>----</option>
<option value="22" <?php if ($row['item_size'] == '22') echo 'selected'; ?>>22</option>
<option value="24" <?php if ($row['item_size'] == '24') echo 'selected'; ?>>24</option>
<option value="26" <?php if ($row['item_size'] == '26') echo 'selected'; ?>>26</option>
<option value="28" <?php if ($row['item_size'] == '28') echo 'selected'; ?>>28</option>
<option value="30" <?php if ($row['item_size'] == '30') echo 'selected'; ?>>30</option>
<option value="32" <?php if ($row['item_size'] == '32') echo 'selected'; ?>>32</option>
<option value="34" <?php if ($row['item_size'] == '34') echo 'selected'; ?>>34</option>
<option value="36" <?php if ($row['item_size'] == '36') echo 'selected'; ?>>36</option>
<option value="38" <?php if ($row['item_size'] == '38') echo 'selected'; ?>>38</option>
<option value="40" <?php if ($row['item_size'] == '40') echo 'selected'; ?>>40</option>
<option value="42" <?php if ($row['item_size'] == '42') echo 'selected'; ?>>42</option>
<option value="44" <?php if ($row['item_size'] == '44') echo 'selected'; ?>>44</option>
<option value="46" <?php if ($row['item_size'] == '46') echo 'selected'; ?>>46</option>
<option value="48" <?php if ($row['item_size'] == '48') echo 'selected'; ?>>48</option>

                </select>
            </div>
        </div>

        <button type="submit" class="btn btn-success">Update Item Profile</button>
    </form>
</div>
</body>
</html>

<?php
$conn->close();
?>
