<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Edit Job Card</title>
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
</head>
<body>
<?php require_once 'menu.html'; ?>
<div class="container mt-5">
    <h2>Edit Job Card</h2>
    <?php
    require_once 'db_connection.php';
    if (isset($_GET['id'])) {
        $id = $_GET['id'];
        $sql = "SELECT * FROM job_cards WHERE id = $id";
        $result = $conn->query($sql);
        $job_card = $result->fetch_assoc();
        
        $sql_items = "SELECT * FROM job_items WHERE job_card_id = $id";
        $items_result = $conn->query($sql_items);
        
        $sql_payments = "SELECT * FROM job_payments WHERE job_card_id = $id";
        $payments_result = $conn->query($sql_payments);
    }
    ?>
    <form id="job_card_form" method="POST" action="update_job_card.php">
        <input type="hidden" name="id" value="<?php echo $job_card['id']; ?>">
        <div class="form-row">
            <div class="form-group col-md-6">
                <label for="name">Customer Name:</label>
                <input type="text" class="form-control" id="name" name="name" value="<?php echo $job_card['name']; ?>" required>
            </div>
            <div class="form-group col-md-6">
                <label for="address">Address:</label>
                <input type="text" class="form-control" id="address" name="address" value="<?php echo $job_card['address']; ?>" required>
            </div>
        </div>
        <div class="form-row">
            <div class="form-group col-md-6">
                <label for="nic_no">NIC No:</label>
                <input type="text" class="form-control" id="nic_no" name="nic_no" value="<?php echo $job_card['nic_no']; ?>" required>
            </div>
            <div class="form-group col-md-6">
                <label for="date">Date:</label>
                <input type="date" class="form-control" id="date" name="date" value="<?php echo $job_card['date']; ?>" required>
            </div>
        </div>
        <div class="form-row">
            <div class="form-group col-md-6">
                <label for="fiton_date">Fit-on Date:</label>
                <input type="date" class="form-control" id="fiton_date" name="fiton_date" value="<?php echo $job_card['fiton_date']; ?>" required>
            </div>
            <div class="form-group col-md-6">
                <label for="final_fiton_date">Final Fit-on Date:</label>
                <input type="date" class="form-control" id="final_fiton_date" name="final_fiton_date" value="<?php echo $job_card['final_fiton_date']; ?>" required>
            </div>
        </div>
        <div class="form-row">
            <div class="form-group col-md-6">
                <label for="payment">Total Payment:</label>
                <input type="number" step="0.01" class="form-control" id="payment" name="payment" value="<?php echo $job_card['total_payment']; ?>" required readonly>
            </div>
            <div class="form-group col-md-6">
                <label for="balance">Balance:</label>
                <input type="number" step="0.01" class="form-control" id="balance" name="balance" required readonly>
            </div>
            <div class="form-group col-md-6">
                <label for="job_action">Job Action:</label>
                <select id="job_action" name="job_action" class="form-control" required>
                    <option value="Pending" <?php echo ($job_card['job_action'] == 'Pending') ? 'selected' : ''; ?>>Pending</option>
                    <option value="Complete" <?php echo ($job_card['job_action'] == 'Complete') ? 'selected' : ''; ?>>Complete</option>
                </select>
            </div>
        </div>
        
        <h4>Job Items</h4>
        <table class="table table-bordered" id="job_items_table">
            <thead>
                <tr>
                    <th>Item Code</th>
                    <th>Item Name</th>
                    <th>Payment</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody>
                <?php
                if ($items_result->num_rows > 0) {
                    while ($item = $items_result->fetch_assoc()) {
                        echo '<tr>';
                        echo '<td><input type="text" name="items[' . $item['id'] . '][item_code]" class="form-control item-code" value="' . $item['item_code'] . '" required></td>';
                        echo '<td><input type="text" name="items[' . $item['id'] . '][item_name]" class="form-control item-name" value="' . $item['item_name'] . '" required readonly></td>';
                        echo '<td><input type="number" step="0.01" name="items[' . $item['id'] . '][payment]" class="form-control item-payment" value="' . $item['payment'] . '" required></td>';
                        echo '<td><button type="button" class="btn btn-danger remove-item-row">Remove</button></td>';
                        echo '</tr>';
                    }
                } else {
                    echo '<tr>';
                    echo '<td><input type="text" name="items[0][item_code]" class="form-control item-code" required></td>';
                    echo '<td><input type="text" name="items[0][item_name]" class="form-control item-name" required readonly></td>';
                    echo '<td><input type="number" step="0.01" name="items[0][payment]" class="form-control item-payment" required></td>';
                    echo '<td><button type="button" class="btn btn-danger remove-item-row">Remove</button></td>';
                    echo '</tr>';
                }
                ?>
            </tbody>
        </table>
        <button type="button" class="btn btn-primary" id="add_item_row">Add Item</button>
        
        <h4>Job Payments</h4>
        <table class="table table-bordered" id="job_payments_table">
            <thead>
                <tr>
                    <th>Date</th>
                    <th>Payment Type</th>
                    <th>Payment Amount</th>
                    <th>Payment By</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody>
                <?php
                if ($payments_result->num_rows > 0) {
                    while ($payment = $payments_result->fetch_assoc()) {
                        echo '<tr>';
                        echo '<td><input type="date" name="payments[' . $payment['id'] . '][date]" class="form-control" value="' . $payment['date'] . '" required></td>';
                        echo '<td><select name="payments[' . $payment['id'] . '][payment_type]" class="form-control" required>';
                        echo '<option value="Advance"' . ($payment['payment_type'] == 'Advance' ? ' selected' : '') . '>Advance</option>';
                        echo '<option value="Balance"' . ($payment['payment_type'] == 'Balance' ? ' selected' : '') . '>Balance</option>';
                        echo '</select></td>';
                        echo '<td><input type="number" step="0.01" name="payments[' . $payment['id'] . '][payment_amount]" class="form-control payment-amount" value="' . $payment['payment_amount'] . '" required></td>';
                        echo '<td><select name="payments[' . $payment['id'] . '][payment_by]" class="form-control" required>';
                        echo '<option value="Cash"' . ($payment['payment_by'] == 'Cash' ? ' selected' : '') . '>Cash</option>';
                        echo '<option value="Check"' . ($payment['payment_by'] == 'Check' ? ' selected' : '') . '>Check</option>';
                        echo '<option value="Credit"' . ($payment['payment_by'] == 'Credit' ? ' selected' : '') . '>Credit</option>';
                        echo '<option value="Credit Card"' . ($payment['payment_by'] == 'Credit Card' ? ' selected' : '') . '>Credit Card</option>';
                        echo '<option value="Online Transfer"' . ($payment['payment_by'] == 'Online Transfer' ? ' selected' : '') . '>Online Transfer</option>';
                        echo '</select></td>';
                        echo '<td><button type="button" class="btn btn-danger remove-payment-row">Remove</button></td>';
                        echo '</tr>';
                    }
                } else {
                    echo '<tr>';
                    echo '<td><input type="date" name="payments[0][date]" class="form-control" required></td>';
                    echo '<td><select name="payments[0][payment_type]" class="form-control" required>';
                    echo '<option value="Advance">Advance</option>';
                    echo '<option value="Balance">Balance</option>';
                    echo '</select></td>';
                    echo '<td><input type="number" step="0.01" name="payments[0][payment_amount]" class="form-control payment-amount" required></td>';
                    echo '<td><select name="payments[0][payment_by]" class="form-control" required>';
                    echo '<option value="Cash">Cash</option>';
                    echo '<option value="Check">Check</option>';
                    echo '<option value="Credit">Credit</option>';
                    echo '<option value="Credit Card">Credit Card</option>';
                    echo '<option value="Online Transfer">Online Transfer</option>';
                    echo '</select></td>';
                    echo '<td><button type="button" class="btn btn-danger remove-payment-row">Remove</button></td>';
                    echo '</tr>';
                }
                ?>
            </tbody>
        </table>
        <button type="button" class="btn btn-primary" id="add_payment_row">Add Payment</button>
        
        <button type="submit" class="btn btn-success mt-3">Update Job Card</button>
    </form>
</div>
<script>
$(document).ready(function() {
    // Function to add new item row
    $('#add_item_row').click(function() {
        var newRow = '<tr>' +
            '<td><input type="text" name="items[0][item_code]" class="form-control item-code" required></td>' +
            '<td><input type="text" name="items[0][item_name]" class="form-control item-name" required readonly></td>' +
            '<td><input type="number" step="0.01" name="items[0][payment]" class="form-control item-payment" required></td>' +
            '<td><button type="button" class="btn btn-danger remove-item-row">Remove</button></td>' +
            '</tr>';
        $('#job_items_table tbody').append(newRow);
    });

    // Function to add new payment row
    $('#add_payment_row').click(function() {
        var newRow = '<tr>' +
            '<td><input type="date" name="payments[0][date]" class="form-control" required></td>' +
            '<td><select name="payments[0][payment_type]" class="form-control" required>' +
            '<option value="Advance">Advance</option>' +
            '<option value="Balance">Balance</option>' +
            '</select></td>' +
            '<td><input type="number" step="0.01" name="payments[0][payment_amount]" class="form-control payment-amount" required></td>' +
            '<td><select name="payments[0][payment_by]" class="form-control" required>' +
            '<option value="Cash">Cash</option>' +
            '<option value="Check">Check</option>' +
            '<option value="Credit">Credit</option>' +
            '<option value="Credit Card">Credit Card</option>' +
            '<option value="Online Transfer">Online Transfer</option>' +
            '</select></td>' +
            '<td><button type="button" class="btn btn-danger remove-payment-row">Remove</button></td>' +
            '</tr>';
        $('#job_payments_table tbody').append(newRow);
    });

    // Function to remove item row
    $(document).on('click', '.remove-item-row', function() {
        $(this).closest('tr').remove();
        calculateTotalPayment();
        calculateBalance();
    });

    // Function to remove payment row
    $(document).on('click', '.remove-payment-row', function() {
        $(this).closest('tr').remove();
        calculateBalance();
    });

    // Function to calculate total payment
    function calculateTotalPayment() {
        var totalPayment = 0;
        $('.item-payment').each(function() {
            totalPayment += parseFloat($(this).val()) || 0;
        });
        $('#payment').val(totalPayment.toFixed(2));
    }

    // Function to calculate balance
    function calculateBalance() {
        var totalPayment = parseFloat($('#payment').val()) || 0;
        var totalPaid = 0;
        $('.payment-amount').each(function() {
            totalPaid += parseFloat($(this).val()) || 0;
        });
        var balance = totalPayment - totalPaid;
        $('#balance').val(balance.toFixed(2));
    }

    // Recalculate total payment and balance when item payment changes
    $(document).on('input', '.item-payment', function() {
        calculateTotalPayment();
        calculateBalance();
    });

    // Recalculate balance when payment amount changes
    $(document).on('input', '.payment-amount', function() {
        calculateBalance();
    });

    // Initial calculation of total payment and balance
    calculateTotalPayment();
    calculateBalance();
});
</script>
</body>
</html>
