<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Edit Invoice</title>
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
    <style>
        .form-group {
            margin-bottom: 15px;
        }
        .table thead th {
            vertical-align: middle;
        }
        .section-header {
            background-color: #f8f9fa;
            padding: 10px;
            margin-bottom: 20px;
            border: 1px solid #dee2e6;
            border-radius: 5px;
        }
    </style>
</head>
<body>
<?php require_once 'menu.html';?>
<div class="container mt-5">
    <h2 class="text-center">Edit Invoice</h2>
    <?php
require_once 'db_connection.php';

if (isset($_GET['invoice_no'])) {
    $invoice_no = $_GET['invoice_no'];

    // Fetch invoice details
    $sql_invoice = "SELECT * FROM invoice_master WHERE invoice_no = '$invoice_no'";
    $result_invoice = $conn->query($sql_invoice);
    $invoice = $result_invoice->fetch_assoc();

    // Fetch items related to this invoice
    $sql_items = "SELECT * FROM invoice_details WHERE invoice_no = '$invoice_no'";
    $result_items = $conn->query($sql_items);

    // Fetch payments related to this invoice
    $sql_payments = "SELECT * FROM invoice_payment_details WHERE invoice_no = '$invoice_no'";
    $result_payments = $conn->query($sql_payments);
}

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $invoice_no = $_POST['invoice_no'];
    $customer_name = $_POST['customer_name'];
    $invoice_date = $_POST['invoice_date'];
    $salesman = $_POST['salesman'];
    $address = $_POST['address'];
    $discount = $_POST['discount'];

    // Update invoice_master
    $sql_update_master = "UPDATE invoice_master SET customer_name = '$customer_name', invoice_date = '$invoice_date', salesman = '$salesman', address = '$address', discount = '$discount' WHERE invoice_no = '$invoice_no'";
    $conn->query($sql_update_master);

    // Delete old invoice details
    $conn->query("DELETE FROM invoice_details WHERE invoice_no = '$invoice_no'");

    // Insert updated items into invoice_details
    $total_amount = 0;
    foreach ($_POST['items'] as $item) {
        $item_id = $item['item_id'];
        $item_name = $item['item_name'];
        $item_price = $item['item_price'];
        $quantity = $item['quantity'];
        $subtotal = $item_price * $quantity;
        $total_amount += $subtotal;

        $sql_details = "INSERT INTO invoice_details (invoice_no, item_id, item_name, item_price, quantity, subtotal) VALUES ('$invoice_no', '$item_id', '$item_name', '$item_price', '$quantity', '$subtotal')";
        $conn->query($sql_details);
    }

    // Delete old payments
    $conn->query("DELETE FROM invoice_payment_details WHERE invoice_no = '$invoice_no'");

    // Insert updated payments into invoice_payment_details
    $total_payment = 0;
    foreach ($_POST['payments'] as $payment) {
        $payment_amount = $payment['payment'];
        $payment_type = $payment['payment_type'];
        $payment_date = $payment['payment_date'];
        $payment_remark = $payment['remark'];
        $total_payment += $payment_amount;

        $sql_payment = "INSERT INTO invoice_payment_details (invoice_no, payment, payment_type, payment_date, remark) VALUES ('$invoice_no', '$payment_amount', '$payment_type', '$payment_date', '$payment_remark')";
        $conn->query($sql_payment);
    }

    // Update total_amount and balance in invoice_master
    $total_amount_after_discount = $total_amount - ($total_amount * ($discount / 100));
    $balance = $total_amount_after_discount - $total_payment;
    $sql_update_master = "UPDATE invoice_master SET total_amount = '$total_amount_after_discount', balance = '$balance' WHERE invoice_no = '$invoice_no'";
    $conn->query($sql_update_master);

    // Redirect to list_invoices.php after successful update
    header("Location: list_invoices.php");
    exit();
}
?>

    <?php if (isset($invoice)): ?>
    <form id="invoice_form" method="POST">
        <!-- Hidden field for invoice_no -->
        <input type="hidden" name="invoice_no" value="<?php echo $invoice['invoice_no']; ?>">

        <!-- Master Section -->
        <div class="section-header">
            <h4>Master Section</h4>
        </div>
        <div class="form-row">
            <div class="form-group col-md-3">
                <label for="customer_name">Customer Name</label>
                <input type="text" class="form-control" id="customer_name" name="customer_name" value="<?php echo htmlspecialchars($invoice['customer_name']); ?>" required>
            </div>
            <div class="form-group col-md-3">
                <label for="invoice_date">Invoice Date</label>
                <input type="date" class="form-control" id="invoice_date" name="invoice_date" value="<?php echo htmlspecialchars($invoice['invoice_date']); ?>" required>
            </div>
            <div class="form-group col-md-3">
                <label for="salesman">Salesman</label>
                <input type="text" class="form-control" id="salesman" name="salesman" value="<?php echo htmlspecialchars($invoice['salesman']); ?>" required>
            </div>
            <div class="form-group col-md-3">
                <label for="address">Address</label>
                <input type="text" class="form-control" id="address" name="address" value="<?php echo htmlspecialchars($invoice['address']); ?>" required>
            </div>
        </div>

        <!-- Item Details Section -->
        <div class="section-header">
            <h4>Item Details Section</h4>
        </div>
        <table class="table table-bordered" id="item_table">
            <thead>
                <tr>
                    <th>Item ID</th>
                    <th>Item Name</th>
                    <th>Item Price</th>
                    <th>Quantity</th>
                    <th>Subtotal</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody>
                <?php while ($item = $result_items->fetch_assoc()) { ?>
                <tr>
                    <td><input type="text" name="items[<?php echo $item['item_id']; ?>][item_id]" class="form-control item_id" value="<?php echo htmlspecialchars($item['item_id']); ?>" required></td>
                    <td><input type="text" name="items[<?php echo $item['item_id']; ?>][item_name]" class="form-control item_name" value="<?php echo htmlspecialchars($item['item_name']); ?>" readonly required></td>
                    <td><input type="number" step="0.01" name="items[<?php echo $item['item_id']; ?>][item_price]" class="form-control item_price" value="<?php echo htmlspecialchars($item['item_price']); ?>" required></td>
                    <td><input type="number" name="items[<?php echo $item['item_id']; ?>][quantity]" class="form-control quantity" value="<?php echo htmlspecialchars($item['quantity']); ?>" required></td>
                    <td><input type="number" step="0.01" name="items[<?php echo $item['item_id']; ?>][subtotal]" class="form-control subtotal" value="<?php echo htmlspecialchars($item['subtotal']); ?>" readonly required></td>
                    <td><button type="button" class="btn btn-danger remove-row">Remove</button></td>
                </tr>
                <?php } ?>
            </tbody>
        </table>
        <button type="button" class="btn btn-primary" id="add_row">Add Row</button>

        <!-- Payment Section -->
        <div class="section-header mt-4">
            <h4>Payment Section</h4>
        </div>
        <table class="table table-bordered" id="payment_table">
            <thead>
                <tr>
                    <th>Payment</th>
                    <th>Payment Type</th>
                    <th>Date</th>
                    <th>Remark</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody>
                <?php while ($payment = $result_payments->fetch_assoc()) { ?>
                <tr>
                    <td><input type="number" step="0.01" name="payments[<?php echo $payment['payment']; ?>][payment]" class="form-control payment" value="<?php echo htmlspecialchars($payment['payment']); ?>" required></td>
                    <td>
                        <select name="payments[<?php echo $payment['payment']; ?>][payment_type]" class="form-control" required>
                            <option value="cash" <?php echo ($payment['payment_type'] == 'cash') ? 'selected' : ''; ?>>Cash</option>
                            <option value="bank transfer" <?php echo ($payment['payment_type'] == 'bank transfer') ? 'selected' : ''; ?>>Bank Transfer</option>
                            <option value="credit" <?php echo ($payment['payment_type'] == 'credit') ? 'selected' : ''; ?>>Credit</option>
                            <option value="credit card" <?php echo ($payment['payment_type'] == 'credit card') ? 'selected' : ''; ?>>Credit Card</option>
                            <option value="check" <?php echo ($payment['payment_type'] == 'check') ? 'selected' : ''; ?>>Check</option>
                        </select>
                    </td>
                    <td><input type="date" name="payments[<?php echo $payment['payment']; ?>][payment_date]" class="form-control" value="<?php echo htmlspecialchars($payment['payment_date']); ?>" required></td>
                    <td><input type="text" name="payments[<?php echo $payment['payment']; ?>][remark]" class="form-control" value="<?php echo htmlspecialchars($payment['remark']); ?>"></td>
                    <td><button type="button" class="btn btn-danger remove-row">Remove</button></td>
                </tr>
                <?php } ?>
            </tbody>
        </table>
        <button type="button" class="btn btn-primary" id="add_payment_row">Add Row</button>

        <!-- Total and Balance Section -->
        <div class="form-group mt-4">
            <label for="total_amount">Total Amount</label>
            <input type="number" step="0.01" class="form-control" id="total_amount" name="total_amount" value="<?php echo htmlspecialchars($invoice['total_amount']); ?>" readonly>
        </div>
        <div class="form-group">
            <label for="discount">Discount (%)</label>
            <input type="number" step="0.01" class="form-control" id="discount" name="discount" value="<?php echo htmlspecialchars($invoice['discount']); ?>" required>
        </div>
        <div class="form-group">
            <label for="balance">Balance</label>
            <input type="number" step="0.01" class="form-control" id="balance" name="balance" value="<?php echo htmlspecialchars($invoice['balance']); ?>" readonly>
        </div>
        <button type="submit" class="btn btn-success">Update</button>
    </form>
    <?php else: ?>
        <div class="alert alert-danger">Invoice not found.</div>
    <?php endif; ?>
</div>

<script>
$(document).ready(function() {
    // Similar JavaScript as in invoice.php to handle item addition, removal, and calculations

    // Add new item row
    let itemIndex = <?php echo $result_items->num_rows; ?>;
    $('#add_row').click(function() {
        let newRow = `<tr>
            <td><input type="text" name="items[${itemIndex}][item_id]" class="form-control item_id" required></td>
            <td><input type="text" name="items[${itemIndex}][item_name]" class="form-control item_name" readonly required></td>
            <td><input type="number" step="0.01" name="items[${itemIndex}][item_price]" class="form-control item_price" required></td>
            <td><input type="number" name="items[${itemIndex}][quantity]" class="form-control quantity" required></td>
            <td><input type="number" step="0.01" name="items[${itemIndex}][subtotal]" class="form-control subtotal" readonly required></td>
            <td><button type="button" class="btn btn-danger remove-row">Remove</button></td>
        </tr>`;
        $('#item_table tbody').append(newRow);
        itemIndex++;
    });

    // Add new payment row
    let paymentIndex = <?php echo $result_payments->num_rows; ?>;
    $('#add_payment_row').click(function() {
        let newRow = `<tr>
            <td><input type="number" step="0.01" name="payments[${paymentIndex}][payment]" class="form-control payment" required></td>
            <td>
                <select name="payments[${paymentIndex}][payment_type]" class="form-control" required>
                    <option value="cash">Cash</option>
                    <option value="bank transfer">Bank Transfer</option>
                    <option value="credit">Credit</option>
                    <option value="credit card">Credit Card</option>
                    <option value="check">Check</option>
                </select>
            </td>
            <td><input type="date" name="payments[${paymentIndex}][payment_date]" class="form-control" required></td>
            <td><input type="text" name="payments[${paymentIndex}][remark]" class="form-control"></td>
            <td><button type="button" class="btn btn-danger remove-row">Remove</button></td>
        </tr>`;
        $('#payment_table tbody').append(newRow);
        paymentIndex++;
    });

    // Remove row
    $(document).on('click', '.remove-row', function() {
        $(this).closest('tr').remove();
        calculateTotal();
        calculateBalance();
    });

    // Calculate subtotal and update total and balance when item quantity or price changes
    $(document).on('input', '.quantity, .item_price', function() {
        let row = $(this).closest('tr');
        let price = parseFloat(row.find('.item_price').val()) || 0;
        let quantity = parseFloat(row.find('.quantity').val()) || 0;
        let subtotal = price * quantity;
        row.find('.subtotal').val(subtotal.toFixed(2));
        calculateTotal();
        calculateBalance();
    });

    // Update balance when discount or payments change
    $('#discount').on('input', function() {
        calculateBalance();
    });
    $(document).on('input', '.payment', function() {
        calculateBalance();
    });

    // Calculate total amount
    function calculateTotal() {
        let total = 0;
        $('.subtotal').each(function() {
            total += parseFloat($(this).val()) || 0;
        });
        $('#total_amount').val(total.toFixed(2));
    }

    // Calculate balance
    function calculateBalance() {
        let total = parseFloat($('#total_amount').val()) || 0;
        let discount = parseFloat($('#discount').val()) || 0;
        let totalPayment = 0;
        $('.payment').each(function() {
            totalPayment += parseFloat($(this).val()) || 0;
        });
        let totalAfterDiscount = total - (total * (discount / 100));
        let balance = totalAfterDiscount - totalPayment;
        $('#balance').val(balance.toFixed(2));
    }

    // Autofill item details based on item ID
    $(document).on('input', '.item_id', function() {
        let itemId = $(this).val();
        let row = $(this).closest('tr');
        if (itemId) {
            $.ajax({
                url: 'fetch_item_invo_details.php',
                type: 'GET',
                data: {item_id: itemId},
                success: function(data) {
                    let item = JSON.parse(data);
                    row.find('.item_name').val(item.item_name);
                    row.find('.item_price').val(item.item_price);
                    row.find('.quantity').trigger('input');
                }
            });
        } else {
            row.find('.item_name, .item_price, .subtotal').val('');
        }
    });
});
</script>
</body>
</html>
