<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Edit GRN</title>
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
    <style>
        .form-group {
            margin-bottom: 15px;
        }
        .table thead th {
            vertical-align: middle;
        }
        .section-header {
            background-color: #f8f9fa;
            padding: 10px;
            margin-bottom: 20px;
            border: 1px solid #dee2e6;
            border-radius: 5px;
        }
    </style>
</head>
<body>
<?php require_once 'menu.html'; ?>
<div class="container mt-5">
    <h2 class="text-center">Edit Goods Received Note (GRN)</h2>
    <?php
    require_once 'db_connection.php';

    if (isset($_GET['grn_no'])) {
        $grn_no = $_GET['grn_no'];

        // Fetch GRN master data
        $sql_master = "SELECT * FROM grn_master WHERE grn_no = '$grn_no'";
        $result_master = $conn->query($sql_master);
        $grn_master = $result_master->fetch_assoc();

        // Fetch GRN details data
        $sql_details = "SELECT * FROM grn_details WHERE grn_no = '$grn_no'";
        $result_details = $conn->query($sql_details);
        $grn_details = [];
        while ($row = $result_details->fetch_assoc()) {
            $grn_details[] = $row;
        }

        // Fetch GRN payment data
        $sql_payment = "SELECT * FROM grn_payment WHERE grn_no = '$grn_no'";
        $result_payment = $conn->query($sql_payment);
        $grn_payments = [];
        while ($row = $result_payment->fetch_assoc()) {
            $grn_payments[] = $row;
        }
    }

    if ($_SERVER["REQUEST_METHOD"] == "POST") {
        $grn_no = $_POST['grn_no'];
        $date = $_POST['date'];
        $supplier_name = $_POST['supplier_name'];
        $remark = $_POST['remark'];

        // Update GRN Master
        $sql_update_master = "UPDATE grn_master SET supplier_name = '$supplier_name', date = '$date', remark = '$remark' WHERE grn_no = '$grn_no'";
        $conn->query($sql_update_master);

        // Update GRN Details
        $conn->query("DELETE FROM grn_details WHERE grn_no = '$grn_no'");
        $total_price = 0;
        foreach ($_POST['items'] as $item) {
            $item_code = $item['item_code'];
            $item_name = $item['item_name'];
            $quantity = $item['quantity'];
            $unit_price = $item['unit_price'];
            $sub_total = $item['sub_total'];
            $total_price += $sub_total;

            $sql_details = "INSERT INTO grn_details (grn_no, item_code, item_name, quantity, unit_price, sub_total) VALUES ('$grn_no', '$item_code', '$item_name', '$quantity', '$unit_price', '$sub_total')";
            $conn->query($sql_details);
        }

        // Update GRN Payment
        $conn->query("DELETE FROM grn_payment WHERE grn_no = '$grn_no'");
        $total_payment = 0;
        foreach ($_POST['payments'] as $payment) {
            $payment_amount = $payment['payment'];
            $total_payment += $payment_amount;
            $payment_type = $payment['payment_type'];
            $payment_date = $payment['payment_date'];
            $payment_remark = $payment['remark'];

            $sql_payment = "INSERT INTO grn_payment (grn_no, payment, payment_type, payment_date, remark) VALUES ('$grn_no', '$payment_amount', '$payment_type', '$payment_date', '$payment_remark')";
            $conn->query($sql_payment);
        }

        // Update GRN Master with totals
        $balance = $total_price - $total_payment;
        $sql_update_totals = "UPDATE grn_master SET total = '$total_price', balance = '$balance' WHERE grn_no = '$grn_no'";
        $conn->query($sql_update_totals);

        echo "<div class='alert alert-success'>GRN updated successfully!</div>";
        header("Location: list_grns.php");
        exit();
    }
    ?>
    <form id="grn_form" method="POST">
        <!-- Master Section -->
        <div class="section-header">
            <h4>Master Section</h4>
        </div>
        <div class="form-row">
            <div class="form-group col-md-2">
                <label for="grn_no">GRN No</label>
                <input type="text" class="form-control" id="grn_no" name="grn_no" value="<?php echo $grn_master['grn_no']; ?>" readonly>
            </div>
            <div class="form-group col-md-4">
                <label for="supplier_name">Supplier Name</label>
                <select class="form-control" id="supplier_name" name="supplier_name" required>
                    <option value="">Select Supplier</option>
                    <?php
                    $sql = "SELECT supplier_name FROM supplier";
                    $result = $conn->query($sql);

                    if ($result->num_rows > 0) {
                        while ($row = $result->fetch_assoc()) {
                            $selected = ($row['supplier_name'] == $grn_master['supplier_name']) ? 'selected' : '';
                            echo "<option value='" . $row['supplier_name'] . "' $selected>" . $row['supplier_name'] . "</option>";
                        }
                    }
                    ?>
                </select>
            </div>
            <div class="form-group col-md-3">
                <label for="date">Date</label>
                <input type="date" class="form-control" id="date" name="date" value="<?php echo $grn_master['date']; ?>" required>
            </div>
            <div class="form-group col-md-3">
                <label for="remark">Remark</label>
                <input type="text" class="form-control" id="remark" name="remark" value="<?php echo $grn_master['remark']; ?>">
            </div>
        </div>

        <!-- Item Details Section -->
        <div class="section-header">
            <h4>Item Details Section</h4>
        </div>
        <table class="table table-bordered" id="item_table">
            <thead>
                <tr>
                    <th>Item Code</th>
                    <th>Item Name</th>
                    <th>Quantity</th>
                    <th>Unit Price</th>
                    <th>Sub Total</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody>
                <?php
                $itemRowIndex = 0;
                foreach ($grn_details as $item) {
                    echo "<tr>
                        <td><input type='text' name='items[$itemRowIndex][item_code]' class='form-control item_code' value='{$item['item_code']}' required></td>
                        <td><input type='text' name='items[$itemRowIndex][item_name]' class='form-control item_name' value='{$item['item_name']}' readonly required></td>
                        <td><input type='number' step='0.01' name='items[$itemRowIndex][quantity]' class='form-control quantity' value='{$item['quantity']}' required></td>
                        <td><input type='number' step='0.01' name='items[$itemRowIndex][unit_price]' class='form-control unit_price' value='{$item['unit_price']}' readonly required></td>
                        <td><input type='number' step='0.01' name='items[$itemRowIndex][sub_total]' class='form-control sub_total' value='{$item['sub_total']}' readonly required></td>
                        <td><button type='button' class='btn btn-danger remove-row'>Remove</button></td>
                    </tr>";
                    $itemRowIndex++;
                }
                ?>
            </tbody>
        </table>
        <button type="button" class="btn btn-primary" id="add_row">Add Row</button>

        <!-- Payment Section -->
        <div class="section-header mt-4">
            <h4>Payment Section</h4>
        </div>
        <table class="table table-bordered" id="payment_table">
            <thead>
                <tr>
                    <th>Payment</th>
                    <th>Payment Type</th>
                    <th>Date</th>
                    <th>Remark</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody>
                <?php
                $paymentRowIndex = 0;
                foreach ($grn_payments as $payment) {
                    echo "<tr>
                        <td><input type='number' step='0.01' name='payments[$paymentRowIndex][payment]' class='form-control payment' value='{$payment['payment']}' required></td>
                        <td>
                            <select name='payments[$paymentRowIndex][payment_type]' class='form-control' required>
                                <option value='cash' " . ($payment['payment_type'] == 'cash' ? 'selected' : '') . ">Cash</option>
                                <option value='credit' " . ($payment['payment_type'] == 'credit' ? 'selected' : '') . ">Credit</option>
                                <option value='credit card' " . ($payment['payment_type'] == 'credit card' ? 'selected' : '') . ">Credit Card</option>
                                <option value='online transfer' " . ($payment['payment_type'] == 'online transfer' ? 'selected' : '') . ">Online Transfer</option>
                                <option value='check' " . ($payment['payment_type'] == 'check' ? 'selected' : '') . ">Check</option>
                            </select>
                        </td>
                        <td><input type='date' name='payments[$paymentRowIndex][payment_date]' class='form-control' value='{$payment['payment_date']}' required></td>
                        <td><input type='text' name='payments[$paymentRowIndex][remark]' class='form-control' value='{$payment['remark']}'></td>
                        <td><button type='button' class='btn btn-danger remove-row'>Remove</button></td>
                    </tr>";
                    $paymentRowIndex++;
                }
                ?>
            </tbody>
        </table>
        <button type="button" class="btn btn-primary" id="add_payment_row">Add Row</button>

        <!-- Total and Balance Section -->
        <div class="form-row">       
        <div class="form-group col-md-3">
            <label for="total_price">Total Price</label>
            <input type="number" step="0.01" class="form-control" id="total_price" name="total_price" value="<?php echo $grn_master['total']; ?>" readonly>
        </div>
        <div class="form-group col-md-3">
            <label for="balance">Balance</label>
            <input type="number" step="0.01" class="form-control" id="balance" name="balance" value="<?php echo $grn_master['balance']; ?>" readonly>
        </div>
        </div>
        <div class="form-group mt-4">
            <button type="submit" class="btn btn-success">Update GRN</button>
        </div>
    </form>
</div>

<script>
$(document).ready(function() {
    $('#add_row').click(function() {
        const index = $('#item_table tbody tr').length;
        $('#item_table tbody').append(`<tr>
            <td><input type="text" name="items[${index}][item_code]" class="form-control item_code" required></td>
            <td><input type="text" name="items[${index}][item_name]" class="form-control item_name" readonly required></td>
            <td><input type="number" name="items[${index}][quantity]" class="form-control quantity" required></td>
            <td><input type="number" step="0.01" name="items[${index}][unit_price]" class="form-control unit_price" readonly required></td>
            <td><input type="number" step="0.01" name="items[${index}][sub_total]" class="form-control sub_total" readonly required></td>
            <td><button type="button" class="btn btn-danger remove-row">Remove</button></td>
        </tr>`);
    });

    $('#add_payment_row').click(function() {
        const index = $('#payment_table tbody tr').length;
        $('#payment_table tbody').append(`<tr>
            <td><input type="number" step="0.01" name="payments[${index}][payment]" class="form-control payment" required></td>
            <td>
                <select name="payments[${index}][payment_type]" class="form-control" required>
                    <option value="cash">Cash</option>
                    <option value="credit">Credit</option>
                    <option value="credit card">Credit Card</option>
                    <option value="online transfer">Online Transfer</option>
                    <option value="check">Check</option>
                </select>
            </td>
            <td><input type="date" name="payments[${index}][payment_date]" class="form-control" required></td>
            <td><input type="text" name="payments[${index}][remark]" class="form-control"></td>
            <td><button type="button" class="btn btn-danger remove-row">Remove</button></td>
        </tr>`);
    });

    $(document).on('click', '.remove-row', function() {
        $(this).closest('tr').remove();
        calculateTotalAndBalance();
    });

    $(document).on('blur', '.item_code', function() {
        const row = $(this).closest('tr');
        const itemCode = $(this).val();
        if (itemCode) {
            $.ajax({
                url: 'fetch_item_details_grn.php',
                type: 'GET',
                data: { item_code: itemCode },
                success: function(data) {
                    const item = JSON.parse(data);
                    row.find('.item_name').val(item.item_name);
                    row.find('.unit_price').val(item.item_price);
                    const quantity = row.find('.quantity').val();
                    row.find('.sub_total').val(quantity * item.item_price);
                    calculateTotalAndBalance();
                }
            });
        }
    });

    $(document).on('blur', '.quantity', function() {
        const row = $(this).closest('tr');
        const quantity = $(this).val();
        const unitPrice = row.find('.unit_price').val();
        row.find('.sub_total').val(quantity * unitPrice);
        calculateTotalAndBalance();
    });

    $(document).on('blur', '.payment', function() {
        calculateTotalAndBalance();
    });

    function calculateTotalAndBalance() {
        let total = 0;
        $('.sub_total').each(function() {
            total += parseFloat($(this).val()) || 0;
        });
        $('#total_price').val(total);

        let totalPayment = 0;
        $('.payment').each(function() {
            totalPayment += parseFloat($(this).val()) || 0;
        });
        $('#balance').val(total - totalPayment);
    }
});
</script>
</body>
</html>
