<?php
require_once 'db_connection.php'; // Your DB connection file

if (isset($_GET['rent_no'])) {
    $rent_no = $_GET['rent_no'];

    // Fetch rent master details
    $sql_master = "SELECT * FROM rent_master WHERE rent_no = ?";
    $stmt_master = $conn->prepare($sql_master);
    $stmt_master->bind_param("i", $rent_no);
    $stmt_master->execute();
    $result_master = $stmt_master->get_result()->fetch_assoc();

    // Fetch rent details
    $sql_details = "SELECT * FROM rent_details WHERE rent_no = ?";
    $stmt_details = $conn->prepare($sql_details);
    $stmt_details->bind_param("i", $rent_no);
    $stmt_details->execute();
    $result_details = $stmt_details->get_result();

    // Fetch payment details
    $sql_payment = "SELECT * FROM rent_payment WHERE rent_no = ?";
    $stmt_payment = $conn->prepare($sql_payment);
    $stmt_payment->bind_param("i", $rent_no);
    $stmt_payment->execute();
    $result_payment = $stmt_payment->get_result();
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Rent Invoice</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 0;
            background-color: #f5f5f5;
            width: 100%;
            max-width: 3in; /* Set max-width to 3 inches */
        }

        .invoice-container {
            width: 100%;
            padding: 5px;
            background-color: #fff;
        }

        .invoice-header {
            text-align: center;
            margin-bottom: 10px;
        }

        .invoice-header img {
            max-width: 100px;
            height: auto;
        }

        .invoice-title {
            text-align: center;
            font-size: 14px;
            font-weight: bold;
            margin-bottom: 10px;
            border-bottom: 1px solid #000;
            padding-bottom: 5px;
        }

        .invoice-info, .payment-details, .notes-section {
            font-size: 10px;
            margin-bottom: 10px;
        }

        .invoice-info p, .payment-details p {
            margin: 3px 0;
        }

        .item-table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 10px;
        }

        .item-table th, .item-table td {
            padding: 5px;
            border: 0px solid #000;
            text-align: left;
            font-size: 10px;
        }

        .item-table th {
            background-color: #f8f9fa;
        }

        .totals-section {
            width: 100%;
            font-size: 10px;
            margin-bottom: 0px;
        }

        .totals-section th, .totals-section td {
            padding: 5px;
            text-align: right;
        }

        .payment-section, .notes-section {
            margin-top: 0px;
            border: 0px solid #000;
            padding: 0px;
        }

        .footer-section {
            text-align: center;
            font-size: 10px;
            margin-top: 0px;
        }

        .footer-section p {
            margin: 5px 0;
        }

        .notes-section {
            font-size: 10px;
            margin-top: 0px;
        }
        .notes-section h5 {
            font-size: 10px;
            margin-bottom: 5px;
        }
        .notes-section p {
            margin: 0;
            padding: 5px;
            border: 1px solid #000;
            text-align: center;
        }

        @media print {
            body, .invoice-container {
                width: 100%;
                max-width: 3in;
            }

            .btn-print {
                display: none;
            }
        }
    </style>
</head>
<body>

<div class="invoice-container">
    <!-- Header Section -->
    <div class="invoice-header">
        <img src="logo.png" alt="Company Logo">
    </div>

    <!-- Invoice Title -->
    <div class="invoice-title">
        Rent Invoice
    </div>

    <!-- Invoice Information -->
    <div class="invoice-info">
        <p><strong>Date:</strong> <?php echo $result_master['date']; ?></p>
        <p><strong>Rent No:</strong> <?php echo $rent_no; ?></p>
        <p><strong>Customer Name:</strong> <?php echo $result_master['name']; ?></p>
        <p><strong>Salesman:</strong> <?php echo $result_master['salesman']; ?></p>
        <p><strong>Booking Date:</strong> <?php echo $result_master['booking_date']; ?></p>
        <p><strong>Return Date:</strong> <?php echo $result_master['hand_over']; ?></p>
    </div>

   <!-- Rent Details -->
<h4>Rent Items</h4>
<table class="item-table">
    <thead>
        <tr>
            <th>Description</th>
            <th>Price</th>
            <th>Quantity</th>
            <th>Total</th>
        </tr>
    </thead>
    <tbody>
        <?php while ($row = $result_details->fetch_assoc()) { ?>
        <!-- Row for the full-width description -->
        <tr>
            <td colspan="4"><?php echo $row['item_code'] . " - " . $row['item_name']; ?></td>
        </tr>
        <!-- Row for Price, Quantity, and Total -->
        <tr>
            <td></td>
            <td><?php echo number_format($row['price'], 2); ?></td>
            <td><?php echo $row['quantity']; ?></td>
            <td><?php echo number_format($row['price'] * $row['quantity'], 2); ?></td>
        </tr>
        <?php } ?>
    </tbody>
</table>

    <hr>

    <!-- Totals Section -->
    <table class="totals-section">
        <tr>
            <th>Total Amount:</th>
            <td><?php echo number_format($result_master['total_amount'], 2); ?></td>
        </tr>
        <?php if ($result_master['discount'] > 0) { ?>
        <tr>
            <th>Discount:</th>
            <td><?php echo number_format($result_master['discount'], 2); ?></td>
        </tr>
        <?php } ?>
        <tr>
            <th>Balance:</th>
            <td><?php echo number_format($result_master['balance'], 2); ?></td>
        </tr>
    </table>
    <hr>

    <!-- Payment Details Section -->
    <div class="payment-section">
        <h5>Payment Details</h5>
        <table class="item-table">
            <thead>
            <tr>
                <th>Date</th>
                <th>Type</th>
                <th>Amount</th>
            </tr>
            </thead>
            <tbody>
            <?php while ($row = $result_payment->fetch_assoc()) { ?>
                <tr>
                    <td><?php echo $row['date']; ?></td>
                    <td><?php echo $row['payment_type']; ?></td>
                    <td><?php echo number_format($row['payment'], 2); ?></td>
                </tr>
            <?php } ?>
            </tbody>
        </table>
    </div>

    <!-- Footer Section -->
    <div class="notes-section">
        <h5>Special Notes and Instructions</h5>
        <p>We will charge Rs.350.00 for an additional day.<br>Opening Hours - 8.00 AM to 6.00 PM</p>
    </div>

    <div class="footer-section">
        <p>NO 255, Colombo Road, Peradeniya</p>
        <p><i class="fa fa-phone"></i> &emsp14; 081 3134005 &emsp14; <i class="fa fa-whatsapp"></i> 076 1499934</p>
        <p><i class="fa fa-envelope"></i> &emsp14; info@janakatailors.lk &emsp14; <i class="fa fa-facebook"></i> &emsp14;Janaka Tailors</p>
    </div>
</div>

</body>
</html>
