<?php
require_once 'db_connection.php';

$id = $_GET['id'];

$stmt = $conn->prepare("SELECT * FROM item_adjustment WHERE id = ?");
$stmt->bind_param("i", $id);
$stmt->execute();
$result = $stmt->get_result();
$item = $result->fetch_assoc();

?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>View Item Adjustment</title>
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <style>
        body {
            background-color: #f8f9fa;
            padding: 20px;
        }
        .container {
            background-color: #fff;
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
        }
    </style>
</head>
<body>
    <div class="container">
        <h2 class="text-center mb-4">View Item Adjustment</h2>
        <div class="form-group">
            <label>Date:</label>
            <p><?= $item['date'] ?></p>
        </div>
        <div class="form-group">
            <label>Item Code:</label>
            <p><?= $item['item_code'] ?></p>
        </div>
        <div class="form-group">
            <label>Item Name:</label>
            <p><?= $item['item_name'] ?></p>
        </div>
        <div class="form-group">
            <label>Quantity:</label>
            <p><?= $item['quantity'] ?></p>
        </div>
        <div class="form-group">
            <label>Status:</label>
            <p><?= $item['status'] ?></p>
        </div>
        <div class="form-group">
            <label>Task:</label>
            <p><?= $item['task'] ?></p>
        </div>
        <div class="form-group">
            <label>Remark:</label>
            <p><?= $item['remark'] ?></p>
        </div>
        <a href="list_item_adjustments.php" class="btn btn-primary">Back to List</a>
    </div>
</body>
</html>
<?php
$stmt->close();
$conn->close();
?>
