<?php
require_once 'db_connection.php';

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $invoice_no = $_POST['invoice_no'];
    $customer_name = $_POST['customer_name'];
    $date = $_POST['date'];
    $salesman = $_POST['salesman'];
    $rtn_value = $_POST['rtn_value'];

    // Insert into customer_return_master
    $stmt = $conn->prepare("INSERT INTO customer_return_master (invoice_no, customer_name, date, salesman, rtn_value) VALUES (?, ?, ?, ?, ?)");
    $stmt->bind_param("ssssd", $invoice_no, $customer_name, $date, $salesman, $rtn_value);
    $stmt->execute();
    $cus_rtn_id = $stmt->insert_id;  // Get the last inserted ID
    $stmt->close();

    // Insert into customer_details
    foreach ($_POST['item_code'] as $key => $item_code) {
        $item_name = $_POST['item_name'][$key];
        $quantity = $_POST['quantity'][$key];
        $amount = $_POST['amount'][$key];
        $subtotal = $_POST['subtotal'][$key];
        $remark = $_POST['remark'][$key];

        $stmt = $conn->prepare("INSERT INTO customer_details (cus_rtn_id, item_code, item_name, quantity, amount, subtotal, remark) VALUES (?, ?, ?, ?, ?, ?, ?)");
        $stmt->bind_param("issddds", $cus_rtn_id, $item_code, $item_name, $quantity, $amount, $subtotal, $remark);
        $stmt->execute();
    }

    $stmt->close();
    $conn->close();

    header("Location: list_cus_rtn.php");  // Redirect to list page
    exit();
}
?>
