<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Rent Report</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f8f9fa;
            padding: 20px;
        }
        .table thead th {
            background-color: #007bff;
            color: white;
        }
    </style>
</head>
<body>
    <div class="container">
        <h1 class="text-center mb-4">Rent Report</h1>
        <div class="card">
            <div class="card-body">
                <?php
                include 'db_connection.php';

                if (isset($_GET['rent_no'])) {
                    $rent_no = intval($_GET['rent_no']);

                    $rent_query = "SELECT * FROM rent_master WHERE rent_no = $rent_no";
                    $rent_result = $conn->query($rent_query);

                    if ($rent_result->num_rows > 0) {
                        $rent = $rent_result->fetch_assoc();
                        echo "<h4>Rent No: " . $rent['rent_no'] . "</h4>";
                        echo "<p><strong>Customer Name:</strong> " . $rent['name'] . "</p>";
                        echo "<p><strong>Date:</strong> " . $rent['date'] . "</p>";
                        echo "<p><strong>Booking Date:</strong> " . $rent['booking_date'] . "</p>";
                        echo "<p><strong>Fiton Date:</strong> " . $rent['fiton_date'] . "</p>";
                        echo "<p><strong>Hand Over Date:</strong> " . $rent['hand_over'] . "</p>";
                        echo "<p><strong>Total Amount:</strong> Rs. " . number_format($rent['total_amount'], 2) . "</p>";
                        echo "<p><strong>Balance:</strong> Rs. " . number_format($rent['balance'], 2) . "</p>";
                        echo "<p><strong>Action:</strong> " . $rent['rent_action'] . "</p>";

                        echo "<h5>Items:</h5>";
                        $items_query = "SELECT * FROM rent_details WHERE rent_no = $rent_no";
                        $items_result = $conn->query($items_query);

                        if ($items_result->num_rows > 0) {
                            echo "<table class='table table-bordered'>";
                            echo "<thead>
                            <tr>
                            <th>Item Name</th>
                            <th>Quantity</th>
                            <th>Price</th>
                            <th>Status</th>
                            </tr>
                            </thead>
                            <tbody>";

                            while ($item = $items_result->fetch_assoc()) {
                                echo "<tr>";
                                echo "<td>" . $item['item_name'] . "</td>";
                                echo "<td>" . $item['quantity'] . "</td>";
                                echo "<td>Rs. " . number_format($item['price'], 2) . "</td>";
                                echo "<td>" . $item['status'] . "</td>";
                                echo "</tr>";
                            }
                            echo "</tbody></table>";
                        } else {
                            echo "<p>No items found for this rent.</p>";
                        }
                    } else {
                        echo "<p>No rent data found for Rent No: $rent_no.</p>";
                    }

                    $conn->close();
                } else {
                    echo "<p>No rent number provided.</p>";
                }
                ?>
            </div>
        </div>
    </div>
</body>
</html>
