<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Create Invoice</title>
   <!-- Bootstrap CSS -->
<link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">

<!-- jQuery and Bootstrap JS -->
<script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
<script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>

    <style>
        .form-group {
            margin-bottom: 15px;
        }
        .table thead th {
            vertical-align: middle;
        }
        .section-header {
            background-color: #f8f9fa;
            padding: 10px;
            margin-bottom: 20px;
            border: 1px solid #dee2e6;
            border-radius: 5px;
        }
        .centa {
  display: flex;
  justify-content: center;
  align-items: center;
  padding: 20px;
}
    </style>
</head>
<body>
<?php require_once 'menu.html';?>
<div class="container mt-5">
    <h2 class="text-center">Create Invoice</h2>
    <?php
    require_once 'db_connection.php';

    // Error Reporting
    error_reporting(E_ALL);
    ini_set('display_errors', 1);

    if ($_SERVER["REQUEST_METHOD"] == "POST") {
        $customer_name = $_POST['customer_name'];
        $invoice_date = $_POST['invoice_date'];
        $salesman = $_POST['salesman'];        
        $discount = $_POST['discount'];

       // Query to get the last invoice number from the database
$sql = "SELECT invoice_no FROM invoice_master ORDER BY id DESC LIMIT 1";
$result = $conn->query($sql);

// Check if there is an existing invoice
if ($result->num_rows > 0) {
    $row = $result->fetch_assoc();
    $last_invoice_no = $row['invoice_no'];

    // Extract the numeric part of the last invoice number
    $numeric_part = (int) substr($last_invoice_no, 3);

    // Increment the numeric part by 1
    $new_invoice_no = $numeric_part + 1;

    // Format the new invoice number with padding
    $invoice_no = 'JT-' . str_pad($new_invoice_no, 4, '0', STR_PAD_LEFT);
} else {
    // If no invoice exists, start from JT-0001
    $invoice_no = 'JT-0001';
}




        // Insert into invoice_master
        $sql_master = "INSERT INTO invoice_master (invoice_no, customer_name, invoice_date, salesman, total_amount, balance, discount) VALUES ('$invoice_no', '$customer_name', '$invoice_date', '$salesman', 0, 0, '$discount')";
        $conn->query($sql_master);

        // Insert into invoice_details
        $total_amount = 0;
        foreach ($_POST['items'] as $item) {
            $item_id = $item['item_id'];
            $item_name = $item['item_name'];
            $item_price = $item['item_price'];
            $quantity = $item['quantity'];
            $subtotal = $item_price * $quantity;
            $total_amount += $subtotal;

            $sql_details = "INSERT INTO invoice_details (invoice_no, item_id, item_name, item_price, quantity, subtotal) VALUES ('$invoice_no', '$item_id', '$item_name', '$item_price', '$quantity', '$subtotal')";
            $conn->query($sql_details);
        }

        // Insert into invoice_payment_details
        $total_payment = 0;
        foreach ($_POST['payments'] as $payment) {
            $payment_amount = $payment['payment'];
            $payment_type = $payment['payment_type'];
            $payment_date = $payment['payment_date'];
            $payment_remark = $payment['remark'];
            $total_payment += $payment_amount;

            $sql_payment = "INSERT INTO invoice_payment_details (invoice_no, payment, payment_type, payment_date, remark) VALUES ('$invoice_no', '$payment_amount', '$payment_type', '$payment_date', '$payment_remark')";
            $conn->query($sql_payment);
        }

        // Update total_amount and balance in invoice_master
        $total_amount_after_discount = $total_amount - $discount;
        $balance = $total_amount_after_discount - $total_payment;
        $sql_update_master = "UPDATE invoice_master SET total_amount = ' $total_amount', balance = '$balance' WHERE invoice_no = '$invoice_no'";
        $conn->query($sql_update_master);

        echo "<div class='alert alert-success'>Invoice created successfully!</div>";
    }
    ?>
    <form id="invoice_form" method="POST">
        <!-- Master Section -->
        <div class="section-header">
            <h4>Master Section</h4>
        </div>
        <div class="form-row">
          


        <div class="form-group col-md-3">
               
           <label for="customer_name">Customer Name</label>
            <input list="customer_list" id="customer_name" name="customer_name" class="form-control" required placeholder="Start typing customer name..." autocomplete="off">

                <datalist id="customer_list">
                <?php
                require_once 'db_connection.php';

                // Fetch customer names from the database
                 $sql = "SELECT * FROM customer_profile";
                 $result = $conn->query($sql);

                if ($result->num_rows > 0) {
                    while ($row = $result->fetch_assoc()) {
                        echo "<option value='" . $row['customer_name'] . "'>" 
                             . $row['customer_name'] . " [NIC: " . $row['nic_no'] . "] [TP: " . $row['cus_tp'] . "]</option>";
                    }
    }
    ?>
</datalist>

            </div>

            <div class="form-group col-md-1 centa">            
                <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#customerModal">+</button>
            </div>

            <div class="form-group col-md-2">
                <label for="invoice_date">Invoice Date</label>
                <input type="date" class="form-control" id="invoice_date" name="invoice_date" required>
            </div>
            <div class="form-group col-md-3">
                <label for="salesman">Salesman</label>
                <input type="text" class="form-control" id="salesman" name="salesman" required>
            </div>
          
        </div>

        <!-- Item Details Section -->
        <div class="section-header">
            <h4>Item Details Section</h4>
        </div>
        <table class="table table-bordered" id="item_table">
            <thead>
                <tr>
                    <th>Item ID</th>
                    <th>Item Name</th>
                    <th>Item Price</th>
                    <th>Quantity</th>
                    <th>Subtotal</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <td><input type="text" name="items[0][item_id]" class="form-control item_id" required></td>
                    <td><input type="text" name="items[0][item_name]" class="form-control item_name" readonly required></td>
                    <td><input type="number" step="0.01" name="items[0][item_price]" class="form-control item_price" required></td>
                    <td><input type="number" name="items[0][quantity]" class="form-control quantity" required></td>
                    <td><input type="number" step="0.01" name="items[0][subtotal]" class="form-control subtotal" readonly required></td>
                    <td><button type="button" class="btn btn-danger remove-row">Remove</button></td>
                </tr>
            </tbody>
        </table>
        <button type="button" class="btn btn-primary" id="add_row">Add Row</button>

        <!-- Payment Section -->
        <div class="section-header mt-4">
            <h4>Payment Section</h4>
        </div>
        <table class="table table-bordered" id="payment_table">
            <thead>
                <tr>
                    <th>Payment</th>
                    <th>Payment Type</th>
                    <th>Date</th>
                    <th>Remark</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <td><input type="number" step="0.01" name="payments[0][payment]" class="form-control payment" required></td>
                    <td>
                        <select name="payments[0][payment_type]" class="form-control" required>
                            <option value="cash">Cash</option>
                            <option value="bank transfer">Bank Transfer</option>
                            <option value="credit">Credit</option>
                            <option value="credit card">Credit Card</option>
                            <option value="check">Check</option>
                        </select>
                    </td>
                    <td><input type="date" name="payments[0][payment_date]" class="form-control" required></td>
                    <td><input type="text" name="payments[0][remark]" class="form-control"></td>
                    <td><button type="button" class="btn btn-danger remove-row">Remove</button></td>
                </tr>
            </tbody>
        </table>
        <button type="button" class="btn btn-primary" id="add_payment_row">Add Row</button>

        <!-- Total and Balance Section -->
        <div class="form-group mt-4">
            <label for="total_amount">Total Amount</label>
            <input type="number" step="0.01" class="form-control" id="total_amount" name="total_amount" readonly>
        </div>
        <div class="form-group">
            <label for="discount">Discount (%)</label>
            <input type="number" step="0.01" class="form-control" id="discount" name="discount" value= 0 required>
        </div>
        <div class="form-group">
            <label for="balance">Balance</label>
            <input type="number" step="0.01" class="form-control" id="balance" name="balance" readonly>
        </div>
        <button type="submit" class="btn btn-success">Submit</button>
    </form>
</div>






<!-- Customer Modal -->
<div class="modal fade" id="customerModal" tabindex="-1" role="dialog" aria-labelledby="customerModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="customerModalLabel">Select Customer</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <iframe id="customerIframe" src="add_customer.php" style="width: 100%; height: 400px; border: none;"></iframe>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                <button type="button" class="btn btn-primary" id="selectCustomerBtn">Select</button>
            </div>
        </div>
    </div>
</div>


<script>
$(document).ready(function() {
    // Add new item row
    let itemIndex = 1;
    $('#add_row').click(function() {
        let newRow = `<tr>
            <td><input type="text" name="items[${itemIndex}][item_id]" class="form-control item_id" required></td>
            <td><input type="text" name="items[${itemIndex}][item_name]" class="form-control item_name" readonly required></td>
            <td><input type="number" step="0.01" name="items[${itemIndex}][item_price]" class="form-control item_price" required></td>
            <td><input type="number" name="items[${itemIndex}][quantity]" class="form-control quantity" required></td>
            <td><input type="number" step="0.01" name="items[${itemIndex}][subtotal]" class="form-control subtotal" readonly required></td>
            <td><button type="button" class="btn btn-danger remove-row">Remove</button></td>
        </tr>`;
        $('#item_table tbody').append(newRow);
        itemIndex++;
    });

    // Add new payment row
    let paymentIndex = 1;
    $('#add_payment_row').click(function() {
        let newRow = `<tr>
            <td><input type="number" step="0.01" name="payments[${paymentIndex}][payment]" class="form-control payment" required></td>
            <td>
                <select name="payments[${paymentIndex}][payment_type]" class="form-control" required>
                    <option value="cash">Cash</option>
                    <option value="bank transfer">Bank Transfer</option>
                    <option value="credit">Credit</option>
                    <option value="credit card">Credit Card</option>
                    <option value="check">Check</option>
                </select>
            </td>
            <td><input type="date" name="payments[${paymentIndex}][payment_date]" class="form-control" required></td>
            <td><input type="text" name="payments[${paymentIndex}][remark]" class="form-control"></td>
            <td><button type="button" class="btn btn-danger remove-row">Remove</button></td>
        </tr>`;
        $('#payment_table tbody').append(newRow);
        paymentIndex++;
    });

    // Remove row
    $(document).on('click', '.remove-row', function() {
        $(this).closest('tr').remove();
        calculateTotal();
        calculateBalance();
    });

    // Calculate subtotal and update total and balance when item quantity or price changes
    $(document).on('input', '.quantity, .item_price', function() {
        let row = $(this).closest('tr');
        let price = parseFloat(row.find('.item_price').val()) || 0;
        let quantity = parseFloat(row.find('.quantity').val()) || 0;
        let subtotal = price * quantity;
        row.find('.subtotal').val(subtotal.toFixed(2));
        calculateTotal();
        calculateBalance();
    });

    // Update balance when discount or payments change
    $('#discount').on('input', function() {
        calculateBalance();
    });
    $(document).on('input', '.payment', function() {
        calculateBalance();
    });

    // Calculate total amount
    function calculateTotal() {
        let total = 0;
        $('.subtotal').each(function() {
            total += parseFloat($(this).val()) || 0;
        });
        $('#total_amount').val(total.toFixed(2));
    }

    // Calculate balance
    function calculateBalance() {
        let total = parseFloat($('#total_amount').val()) || 0;
        let discount = parseFloat($('#discount').val()) || 0;
        let totalPayment = 0;
        $('.payment').each(function() {
            totalPayment += parseFloat($(this).val()) || 0;
        });
        let totalAfterDiscount = total - discount ;
        let balance = totalAfterDiscount - totalPayment;
        $('#balance').val(balance.toFixed(2));
    }

    // Autofill item details based on item ID
    $(document).on('input', '.item_id', function() {
        let itemId = $(this).val();
        let row = $(this).closest('tr');
        if (itemId) {
            $.ajax({
                url: 'fetch_item_invo_details.php',
                type: 'GET',
                data: {item_id: itemId},
                success: function(data) {
                    let item = JSON.parse(data);
                    row.find('.item_name').val(item.item_name);
                    row.find('.item_price').val(item.item_price);
                    row.find('.quantity').trigger('input');
                }
            });
        } else {
            row.find('.item_name, .item_price, .subtotal').val('');
        }
    });
});
</script>
</body>
</html>
