<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Edit Item Adjustment</title>
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <style>
        body {
            background-color: #f8f9fa;
            padding: 20px;
        }
        .container {
            background-color: #fff;
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
        }
        .form-table td {
            vertical-align: middle;
        }
    </style>
</head>
<body>
<?php
require_once 'menu.html';
require_once 'db_connection.php';

// Get adjustment data by adjustment ID
$adjustment_id = $_GET['id'];
$query = $conn->prepare("SELECT * FROM item_adjustment WHERE id = ?");
$query->bind_param("i", $adjustment_id);
$query->execute();
$result = $query->get_result();
$adjustments = $result->fetch_all(MYSQLI_ASSOC);
?>

<div class="container">
    <h2 class="text-center">Edit Item Adjustment</h2>
    <form action="update_item_adjustment.php" method="POST">
        <input type="hidden" name="adjustment_id" value="<?php echo $adjustment_id; ?>">
        <div class="form-group">
            <label for="date">Date</label>
            <input type="date" class="form-control" id="date" name="date" value="<?php echo $adjustments[0]['date']; ?>" required>
        </div>

        <table class="table table-bordered form-table">
            <thead>
                <tr>
                    <th>Item Code</th>
                    <th>Item Name</th>
                    <th>Quantity</th>
                    <th>Status</th>
                    <th>Task</th>
                    <th>Remark</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody id="adjustment-rows">
                <?php foreach ($adjustments as $index => $adjustment) : ?>
                <tr id="row_<?php echo $index; ?>">
                    <td><input type="text" class="form-control" name="item_code[]" value="<?php echo $adjustment['item_code']; ?>" required onblur="fetchItemName(this, <?php echo $index; ?>)"></td>
                    <td><input type="text" class="form-control" name="item_name[]" value="<?php echo $adjustment['item_name']; ?>" readonly required></td>
                    <td><input type="number" step="0.01" class="form-control" name="quantity[]" value="<?php echo $adjustment['quantity']; ?>" required></td>
                    <td>
                        <select class="form-control" name="status[]" required>
                            <option value="Washing" <?php echo ($adjustment['status'] == 'Washing') ? 'selected' : ''; ?>>Washing</option>
                            <option value="Damage" <?php echo ($adjustment['status'] == 'Damage') ? 'selected' : ''; ?>>Damage</option>
                            <option value="Peradeniya Shop" <?php echo ($adjustment['status'] == 'Peradeniya Shop') ? 'selected' : ''; ?>>Peradeniya Shop</option>
                            <option value="Other" <?php echo ($adjustment['status'] == 'Other') ? 'selected' : ''; ?>>Other</option>
                        </select>
                    </td>
                    <td>
                        <select class="form-control" name="task[]" required>
                            <option value="In" <?php echo ($adjustment['task'] == 'In') ? 'selected' : ''; ?>>In</option>
                            <option value="Out" <?php echo ($adjustment['task'] == 'Out') ? 'selected' : ''; ?>>Out</option>
                        </select>
                    </td>
                    <td><textarea class="form-control" name="remark[]" rows="2"><?php echo $adjustment['remark']; ?></textarea></td>
                    <td><button type="button" class="btn btn-danger" onclick="deleteRow(<?php echo $index; ?>)">Delete</button></td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>

        <button type="button" class="btn btn-success" onclick="addRow()">Add Row</button>
        <button type="submit" class="btn btn-primary mt-3">Update Adjustments</button>
    </form>
</div>

<script>
    let rowCount = <?php echo count($adjustments); ?>;

    function addRow() {
        let tableBody = document.getElementById("adjustment-rows");
        let row = tableBody.insertRow(rowCount);
        row.id = `row_${rowCount}`;

        row.innerHTML = `
            <td><input type="text" class="form-control" name="item_code[]" required onblur="fetchItemName(this, ${rowCount})"></td>
            <td><input type="text" class="form-control" name="item_name[]" readonly required></td>
            <td><input type="number" step="0.01" class="form-control" name="quantity[]" required></td>
            <td>
                <select class="form-control" name="status[]" required>
                    <option value="">Select Status</option>
                    <option value="Washing">Washing</option>
                    <option value="Damage">Damage</option>
                    <option value="Peradeniya Shop">Peradeniya Shop</option>
                    <option value="Other">Other</option>
                </select>
            </td>
            <td>
                <select class="form-control" name="task[]" required>
                    <option value="">Select Task</option>
                    <option value="In">In</option>
                    <option value="Out">Out</option>
                </select>
            </td>
            <td><textarea class="form-control" name="remark[]" rows="2"></textarea></td>
            <td><button type="button" class="btn btn-danger" onclick="deleteRow(${rowCount})">Delete</button></td>
        `;
        rowCount++;
    }

    function deleteRow(index) {
        document.getElementById(`row_${index}`).remove();
    }

    function fetchItemName(input, rowId) {
        var itemCode = input.value;
        if (itemCode) {
            fetch("fetch_item_ajest_name.php?item_code=" + itemCode)
                .then(response => response.json())
                .then(data => {
                    let itemNameField = document.querySelector(`#row_${rowId} input[name="item_name[]"]`);
                    itemNameField.value = data.item_name ? data.item_name : "Item not found";
                });
        }
    }
</script>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
