<?php
require_once 'db_connection.php'; // Include your database connection file

// Get the record ID from the URL
$id = $_GET['id'];

// Fetch the existing record
$stmt = $conn->prepare("SELECT * FROM income_expenses WHERE id = ?");
$stmt->bind_param("i", $id);
$stmt->execute();
$result = $stmt->get_result();
$record = $result->fetch_assoc();
$stmt->close();

// Check if the form is submitted for updating the record
if ($_SERVER["REQUEST_METHOD"] == "POST") {

    // Retrieve updated form data
    $date = $_POST['date'];
    $status = $_POST['status'];
    $description = $_POST['description'];
    $remark = $_POST['remark'];
    $amount = $_POST['amount'];

    // Update the record
    $stmt = $conn->prepare("UPDATE income_expenses SET date = ?, status = ?, description = ?, remark = ?, amount = ? WHERE id = ?");
    $stmt->bind_param("ssssdi", $date, $status, $description, $remark, $amount, $id);

    if ($stmt->execute()) {
        echo "<script>alert('Record updated successfully!');</script>";
        echo "<script>window.location.href = 'list_income_expenses.php';</script>";
    } else {
        echo "<script>alert('Error: Could not update the record.');</script>";
    }

    $stmt->close();
}

$conn->close();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Edit Income & Expense</title>
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <style>
        body {
            background-color: #f8f9fa;
            padding: 20px;
        }
        .container {
            background-color: #fff;
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
        }
    </style>
</head>
<body>
<?php require_once 'menu.html';?>
    <div class="container">
        <h2 class="text-center">Edit Income & Expense</h2>
        <form action="" method="POST">
            <div class="form-group">
                <label for="date">Date</label>
                <input type="date" class="form-control" id="date" name="date" value="<?= $record['date'] ?>" required>
            </div>
            <div class="form-group">
                <label for="status">Status</label>
                <select class="form-control" id="status" name="status" required>
                    <option value="In" <?= $record['status'] == 'In' ? 'selected' : '' ?>>In</option>
                    <option value="Out" <?= $record['status'] == 'Out' ? 'selected' : '' ?>>Out</option>
                    <option value="Opening Balance" <?= $record['status'] == 'Opening Balance' ? 'selected' : '' ?>>Opening Balance</option>
                </select>
            </div>
            <div class="form-group">
                <label for="description">Description</label>
                <input type="text" class="form-control" id="description" name="description" value="<?= $record['description'] ?>" required>
            </div>
            <div class="form-group">
                <label for="remark">Remark</label>
                <input type="text" class="form-control" id="remark" name="remark" value="<?= $record['remark'] ?>">
            </div>
            <div class="form-group">
                <label for="amount">Amount</label>
                <input type="number" step="0.01" class="form-control" id="amount" name="amount" value="<?= $record['amount'] ?>" required>
            </div>
            <button type="submit" class="btn btn-primary">Update</button>
            <a href="list_income_expenses.php" class="btn btn-secondary">Cancel</a>
        </form>
    </div>
</body>
</html>
