<?php
require_once 'db_connection.php';

// Fetch all records from customer_return_master
$result = $conn->query("SELECT * FROM customer_return_master");

?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Customer Return List</title>
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">

    <style>
        body {
            background-color: #f8f9fa;
            padding: 20px;
        }
        .container {
            background-color: #fff;
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
        }
        .table th, .table td {
            vertical-align: middle;
        }
        .table th {
            background-color: #f8f9fa;
        }
        .btn-primary {
            background-color: #007bff;
            color: #fff;
            margin-bottom: 20px;
        }
        .btn-primary:hover {
            background-color: #0056b3;
        }
        .btn-edit, .btn-delete, .btn-view {
            margin-right: 5px;
        }
    </style>
</head>
<body>
<?php require_once 'menu.html';?>
    <div class="container">
        <h2 class="text-center">Customer Return List</h2>

        <!-- Create New Button -->
        <div class="text-right">
            <a href="cus_rtn.php" class="btn btn-primary">Create New</a>
        </div>

        <!-- Search Bar -->
        <div class="form-group">
            <input type="text" class="form-control" id="searchInput" placeholder="Search by Invoice No or Return No">
        </div>

        <table class="table table-bordered table-hover mt-4" id="returnTable">
            <thead class="thead-dark">
                <tr>
                    <th>ID</th>
                    <th>Invoice No</th>
                    <th>Customer Name</th>
                    <th>Date</th>
                    <th>Salesman</th>
                    <th>Return Value</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php while ($row = $result->fetch_assoc()): ?>
                    <tr>
                        <td><?= $row['cus_rtn_id'] ?></td>
                        <td><?= $row['invoice_no'] ?></td>
                        <td><?= $row['customer_name'] ?></td>
                        <td><?= $row['date'] ?></td>
                        <td><?= $row['salesman'] ?></td>
                        <td><?= $row['rtn_value'] ?></td>
                        <td>
                            <a href="view_cus_rtn.php?cus_rtn_id=<?= $row['cus_rtn_id'] ?>" class="btn btn-info btn-view">View</a>
                            <a href="edit_cus_rtn.php?cus_rtn_id=<?= $row['cus_rtn_id'] ?>" class="btn btn-warning btn-edit">Edit</a>
                            <a href="delete_cus_rtn.php?cus_rtn_id=<?= $row['cus_rtn_id'] ?>" class="btn btn-danger btn-delete" onclick="return confirm('Are you sure you want to delete this return?');">Delete</a>
                        </td>
                    </tr>
                <?php endwhile; ?>
            </tbody>
        </table>
    </div>

    <script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
    <script>
        // Filter table based on search input
        $(document).ready(function () {
            $("#searchInput").on("keyup", function () {
                var value = $(this).val().toLowerCase();
                $("#returnTable tbody tr").filter(function () {
                    $(this).toggle($(this).text().toLowerCase().indexOf(value) > -1)
                });
            });
        });
    </script>
</body>
</html>
<?php
$conn->close();
?>
