<?php
session_start();

if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit();
}

$role = $_SESSION['role'];

if ($role !== 'admin' && $role !== 'user') {
    echo "Access denied.";
    exit();
}

include 'db_connection.php';

// Fetch categories from the database
$sql = "SELECT category_name FROM category_profile";
$result = $conn->query($sql);
$categories = [];
if ($result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        $categories[] = $row['category_name'];
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Create Item Profile</title>
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
    <script>
       
    </script>
</head>
<body>
<?php require_once 'menu.html';?>
<div class="container mt-5">
    <h2>Create Item Profile</h2>
    <form action="process_create_item_profile.php" method="post">
        <div class="form-row">
            <div class="form-group col-md-6">
                <label for="item_code">Item Code:</label>
                <input type="text" id="item_code" name="item_code" class="form-control"  required>
            </div>
            <div class="form-group col-md-6">
                <label for="item_name">Item Name:</label>
                <input type="text" id="item_name" name="item_name" class="form-control" required>
            </div>
        </div>
        <div class="form-row">
            <div class="form-group col-md-6">
                <label for="item_price">Item Price:</label>
                <input type="number" id="item_price" name="item_price" class="form-control" step="0.01" required>
            </div>
            <div class="form-group col-md-6">
                <label for="item_description">Item Description:</label>
                <textarea id="item_description" name="item_description" class="form-control"></textarea>
            </div>
        </div>
        <div class="form-row">
            <div class="form-group col-md-6">
                <label for="item_category">Item Category:</label>
                <select id="item_category" name="item_category" class="form-control" required>
                    <option value="">Select a Category</option>
                    <?php foreach ($categories as $category): ?>
                        <option value="<?php echo htmlspecialchars($category); ?>"><?php echo htmlspecialchars($category); ?></option>
                    <?php endforeach; ?>
                </select>
            </div>
            <div class="form-group col-md-6">
                <label for="item_type">Item Type:</label>
                <select id="item_type" name="item_type" class="form-control" required>
                    <option value="Raw Material">Raw Material</option>
                    <option value="Rent Item">Rent Item</option>
                    <option value="Sell Item">Sell Item</option>
                </select>
            </div>
        </div>

        <div class="form-row">
            <div class="form-group col-md-6">
                <label for="create_date">Create Date:</label>
                <input type="datetime-local" id="create_date" name="create_date" class="form-control" required>
            </div>

            <div class="form-group col-md-6">
                <label for="Unit_ok">Unit:</label>
                <select id="Unit_ok" name="Unit_ok" class="form-control" required>
                    <option value="Each">Each</option>
                    <option value="Yards">Yards</option>
                    <option value="M">M</option>
                    <option value="KG">KG</option>
                </select>
            </div>
        </div>


        <button type="submit" class="btn btn-success">Create Item Profile</button>
    </form>
</div>
</body>
</html>

<?php
$conn->close();
?>
