<?php
require_once 'db_connection.php'; // Include the database connection

// Initialize variables for filtering
$filter_rent_no = isset($_GET['rent_no']) ? $_GET['rent_no'] : '';
$filter_name = isset($_GET['name']) ? $_GET['name'] : '';
$filter_date_from = isset($_GET['date_from']) ? $_GET['date_from'] : '';
$filter_date_to = isset($_GET['date_to']) ? $_GET['date_to'] : '';

// Build the query with optional filters
$sql = "
SELECT 
    rm.rent_no,
    rm.date,
    rm.hand_over,
    rm.name,
    rm.total_amount,
    rm.balance
FROM 
    rent_master rm
WHERE 
    1=1
";

// Apply filters
if (!empty($filter_rent_no)) {
    $sql .= " AND rm.rent_no = " . intval($filter_rent_no);
}
if (!empty($filter_name)) {
    $sql .= " AND rm.name LIKE '%" . $conn->real_escape_string($filter_name) . "%'";
}
if (!empty($filter_date_from)) {
    $sql .= " AND rm.date >= '" . $conn->real_escape_string($filter_date_from) . "'";
}
if (!empty($filter_date_to)) {
    $sql .= " AND rm.date <= '" . $conn->real_escape_string($filter_date_to) . "'";
}

$sql .= " ORDER BY rm.rent_no";

$result = $conn->query($sql);

// Prepare data for rent details and calculate totals
$rent_data = [];
$total_amount_sum = 0;
$total_balance_sum = 0;

while ($row = $result->fetch_assoc()) {
    $rent_data[$row['rent_no']] = [
        'date' => $row['date'],
        'name' => $row['name'],
        'total_amount' => $row['total_amount'],
        'balance' => $row['balance'],
        'hand_over' => $row['hand_over'],
    ];

    // Accumulate totals
    $total_amount_sum += $row['total_amount'];
    $total_balance_sum += $row['balance'];
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Rent Summary Report</title>
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            background-color: #f8f9fa;
            padding: 20px;
        }
        .card-header {
            background-color: #007bff;
            color: white;
            cursor: pointer;
        }
        .filter-form {
            margin-bottom: 20px;
            background-color: #ffffff;
            padding: 15px;
            border-radius: 5px;
            box-shadow: 0px 2px 5px rgba(0, 0, 0, 0.1);
        }
    </style>
</head>
<body>
    <div class="container">
        <h1 class="text-center mb-4">Rent Summary Report</h1>

        <!-- Search Filter Form -->
        <form class="filter-form" method="GET">
            <div class="row">
                <div class="col-md-3">
                    <label for="rent_no" class="form-label">Rent No</label>
                    <input type="text" class="form-control" id="rent_no" name="rent_no" value="<?php echo htmlspecialchars($filter_rent_no); ?>">
                </div>
                <div class="col-md-3">
                    <label for="name" class="form-label">Name</label>
                    <input type="text" class="form-control" id="name" name="name" value="<?php echo htmlspecialchars($filter_name); ?>">
                </div>
                <div class="col-md-3">
                    <label for="date_from" class="form-label">Date From</label>
                    <input type="date" class="form-control" id="date_from" name="date_from" value="<?php echo htmlspecialchars($filter_date_from); ?>">
                </div>
                <div class="col-md-3">
                    <label for="date_to" class="form-label">Date To</label>
                    <input type="date" class="form-control" id="date_to" name="date_to" value="<?php echo htmlspecialchars($filter_date_to); ?>">
                </div>
            </div>
            <div class="row mt-3">
                <div class="col-md-6">
                    <button type="submit" class="btn btn-primary">Filter</button>
                    <a href="?" class="btn btn-secondary">Reset</a>
                </div>
            </div>
        </form>

        <!-- Rent Summary Table -->
        <table class="table table-striped table-hover">
            <thead>
                <tr>
                    <th>Rent No</th>
                    <th>Date</th>
                    <th>Name</th>
                    <th>Total Amount</th>
                    <th>Balance</th>
                    <th>RT Date</th>
                </tr>
            </thead>
            <tbody>
    <?php if (!empty($rent_data)): ?>
        <?php foreach ($rent_data as $rent_no => $details): ?>
            <!-- Parent Row -->
            <tr data-bs-toggle="collapse" data-bs-target="#details-<?php echo $rent_no; ?>" aria-expanded="false" aria-controls="details-<?php echo $rent_no; ?>">
                <td><?php echo $rent_no; ?></td>
                <td><?php echo $details['date']; ?></td>
                <td><?php echo $details['name']; ?></td>
                <td><?php echo number_format($details['total_amount'], 2); ?></td>
                <td><?php echo number_format($details['balance'], 2); ?></td>
                <td><?php echo $details['hand_over']; ?></td>
            </tr>

            <!-- Detail Row -->
            <tr class="collapse" id="details-<?php echo $rent_no; ?>">
                <td colspan="6">
                    <h5>Details for Rent No: <?php echo $rent_no; ?></h5>
                    <?php
                    // Fetch rented items for the current rent_no
                    $items_sql = "
                    SELECT 
                        rd.item_name,
                        rd.status AS item_status,
                        rd.date AS item_date,
                        rd.quantity,
                        rd.price,
                        (rd.quantity * rd.price) AS total_item_price
                    FROM 
                        rent_details rd
                    WHERE 
                        rd.rent_no = $rent_no
                    ORDER BY 
                        rd.date;
                    ";
                    $items_result = $conn->query($items_sql);

                    // Fetch payments for the current rent_no
                    $payments_sql = "
                    SELECT 
                        rp.date AS payment_date,
                        rp.payment,
                        rp.payment_type,
                        rp.remark
                    FROM 
                        rent_payment rp
                    WHERE 
                        rp.rent_no = $rent_no
                    ORDER BY 
                        rp.date;
                    ";
                    $payments_result = $conn->query($payments_sql);
                    ?>

                    <!-- Rented Items -->
                    <h6>Rented Items</h6>
                    <table class="table table-dark">
                        <thead>
                            <tr>
                                <th>Item Name</th>
                                <th>Status</th>
                                <th>Date</th>
                                <th>Quantity</th>
                                <th>Price</th>
                                <th>Total Price</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php while ($item = $items_result->fetch_assoc()): ?>
                                <tr>
                                    <td><?php echo $item['item_name']; ?></td>
                                    <td><?php echo ucfirst($item['item_status']); ?></td>
                                    <td><?php echo $item['item_date']; ?></td>
                                    <td><?php echo $item['quantity']; ?></td>
                                    <td><?php echo number_format($item['price'], 2); ?></td>
                                    <td><?php echo number_format($item['total_item_price'], 2); ?></td>
                                </tr>
                            <?php endwhile; ?>
                        </tbody>
                    </table>

                    <!-- Payment Details -->
                    <h6>Payment Details</h6>
                    <table class="table table-dark">
                        <thead>
                            <tr>
                                <th>Payment Date</th>
                                <th>Amount</th>
                                <th>Payment Type</th>
                                <th>Remark</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php while ($payment = $payments_result->fetch_assoc()): ?>
                                <tr>
                                    <td><?php echo $payment['payment_date']; ?></td>
                                    <td><?php echo number_format($payment['payment'], 2); ?></td>
                                    <td><?php echo $payment['payment_type']; ?></td>
                                    <td><?php echo $payment['remark']; ?></td>
                                </tr>
                            <?php endwhile; ?>
                        </tbody>
                    </table>
                </td>
            </tr>
        <?php endforeach; ?>
    <?php else: ?>
        <tr>
            <td colspan="6" class="text-center">No records found.</td>
        </tr>
    <?php endif; ?>
</tbody>

            <tfoot>
                <tr>
                    <th colspan="3" class="text-end">Totals:</th>
                    <th><?php echo number_format($total_amount_sum, 2); ?></th>
                    <th><?php echo number_format($total_balance_sum, 2); ?></th>
                    <th></th>
                </tr>
            </tfoot>
        </table>
    </div>

    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>

<?php
$conn->close();
?>
