<?php
require_once 'db_connection.php';

// Fetch distinct item categories and types for the filter form
$categories = $conn->query("SELECT DISTINCT item_category FROM item_profile");
$types = $conn->query("SELECT DISTINCT item_type FROM item_profile");

?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Item Listing Report</title>
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <style>
        body {
            background-color: #f8f9fa;
            padding: 20px;
        }
        .container {
            background-color: #fff;
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
        }
        .table th, .table td {
            vertical-align: middle;
        }
        .table th {
            background-color: #f8f9fa;
        }
        .btn {
            margin-right: 5px;
        }
        @media print {
            .no-print {
                display: none;
            }
            body {
                background-color: #fff;
            }
            .container {
                box-shadow: none;
            }
            .print-header {
                display: block;
                margin-bottom: 20px;
                font-weight: bold;
                font-size: 18px;
                text-align: center;
            }
        }
        .print-header {
            display: none;
        }
    </style>
</head>
<body>
<?php require_once 'menu.html';?>
    <div class="container">
        <?php
        // Prepare the filter details for display
        $categoryText = isset($_GET['item_category']) ? $_GET['item_category'] : "All Categories";
        $typeText = isset($_GET['item_type']) ? $_GET['item_type'] : "All Types";
        ?>

        <h2 class="text-center mb-4">
            Item Listing Report
            <?php if ($categoryText !== "All Categories" || $typeText !== "All Types"): ?>
                <br>
                <span style="font-size: 0.6em;">(Category: <?= $categoryText ?> and  Type: <?= $typeText ?>)</span>
            <?php endif; ?>
        </h2>

        <form method="GET" class="mb-4 no-print">
            <div class="form-row">
                <div class="form-group col-md-4">
                    <label for="item_category">Item Category</label>
                    <select id="item_category" name="item_category" class="form-control">
                        <option value="">All Categories</option>
                        <?php while ($category = $categories->fetch_assoc()): ?>
                            <option value="<?= $category['item_category'] ?>" <?= isset($_GET['item_category']) && $_GET['item_category'] === $category['item_category'] ? 'selected' : '' ?>><?= $category['item_category'] ?></option>
                        <?php endwhile; ?>
                    </select>
                </div>
                <div class="form-group col-md=4">
                    <label for="item_type">Item Type</label>
                    <select id="item_type" name="item_type" class="form-control">
                        <option value="">All Types</option>
                        <?php while ($type = $types->fetch_assoc()): ?>
                            <option value="<?= $type['item_type'] ?>" <?= isset($_GET['item_type']) && $_GET['item_type'] === $type['item_type'] ? 'selected' : '' ?>><?= $type['item_type'] ?></option>
                        <?php endwhile; ?>
                    </select>
                </div>
                <div class="form-group col-md-4 align-self-end">
                    <button type="submit" class="btn btn-primary">Filter</button>
                    <button type="button" class="btn btn-success no-print" onclick="window.print()">Print</button>
                </div>
            </div>
        </form>

        <div class="print-header">
            Item Listing Report
            <?php if ($categoryText !== "All Categories" || $typeText !== "All Types"): ?>
                <br>
                <span style="font-size: 1.2em;">(Category: <?= $categoryText ?>, Type: <?= $typeText ?>)</span>
            <?php endif; ?>
        </div>

        <?php
        $whereClauses = [];
        $params = [];

        if (!empty($_GET['item_category'])) {
            $whereClauses[] = "item_category = ?";
            $params[] = $_GET['item_category'];
        }

        if (!empty($_GET['item_type'])) {
            $whereClauses[] = "item_type = ?";
            $params[] = $_GET['item_type'];
        }

        $whereSQL = '';
        if (count($whereClauses) > 0) {
            $whereSQL = 'WHERE ' . implode(' AND ', $whereClauses);
        }

        $stmt = $conn->prepare("SELECT * FROM item_profile $whereSQL");

        if (count($params) > 0) {
            $stmt->bind_param(str_repeat('s', count($params)), ...$params);
        }

        $stmt->execute();
        $result = $stmt->get_result();

        if ($result->num_rows > 0):
        ?>
            <table class="table table-bordered table-hover">
                <thead class="thead-dark">
                    <tr>
                        <th>Item Code</th>
                        <th>Item Name</th>
                        <th>Item Price</th>
                        <th>Item Category</th>
                        <th>Item Type</th>
                    </tr>
                </thead>
                <tbody>
                    <?php while ($row = $result->fetch_assoc()): ?>
                        <tr>
                            <td><?= $row['item_code'] ?></td>
                            <td><?= $row['item_name'] ?></td>
                            <td><?= $row['item_price'] ?></td>
                            <td><?= $row['item_category'] ?></td>
                            <td><?= $row['item_type'] ?></td>
                        </tr>
                    <?php endwhile; ?>
                </tbody>
            </table>
        <?php else: ?>
            <div class="alert alert-warning" role="alert">
                No items found for the selected criteria.
            </div>
        <?php endif; ?>

    </div>
</body>
</html>
<?php
$stmt->close();
$conn->close();
?>
